/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.service.resolve.GradleSourceSetsContributor;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GradleRootContributor
implements GradleMethodContextContributor {
    private final GradleSourceSetsContributor mySourceSetsContributor;
    private static final Set<String> BUILD_SCRIPT_BLOCKS = ContainerUtil.newHashSet((Object[])new String[]{"subprojects", "allprojects", "beforeEvaluate", "afterEvaluate", "sourceSets"});

    public GradleRootContributor(GradleSourceSetsContributor sourceSetsContributor) {
        this.mySourceSetsContributor = sourceSetsContributor;
    }

    @Override
    public void process(List<String> methodCallInfo, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        String method;
        if (methodCallInfo.size() > 2) {
            return;
        }
        if (methodCallInfo.size() == 2 && !BUILD_SCRIPT_BLOCKS.contains(methodCallInfo.get(1))) {
            return;
        }
        if (methodCallInfo.size() > 0 && (method = (String)ContainerUtil.getLastItem(methodCallInfo)) != null && StringUtil.startsWith((CharSequence)method, (CharSequence)"sourceSets")) {
            this.mySourceSetsContributor.process(methodCallInfo, processor, state, place);
            return;
        }
        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        GradleResolverUtil.processDeclarations(methodCallInfo.size() > 0 ? methodCallInfo.get(0) : null, psiManager, processor, state, place, "org.gradle.api.Project");
    }
}

