/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.extensions.GroovyMapContentProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrReferenceTypeEnhancer;

public class NamedDomainObjectCollectionTypeEnhancer
extends GrReferenceTypeEnhancer {
    public PsiType getReferenceType(GrReferenceExpression ref, PsiElement resolved) {
        PsiElement qResolved;
        if (resolved != null) {
            return null;
        }
        GrExpression qualifierExpression = ref.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        PsiType namedDomainCollectionType = GradleResolverUtil.getTypeOf(qualifierExpression);
        if (!GroovyPsiManager.isInheritorCached((PsiType)namedDomainCollectionType, (String)"org.gradle.api.NamedDomainObjectCollection")) {
            return null;
        }
        if (qualifierExpression instanceof GrReferenceExpression) {
            qResolved = ((GrReferenceExpression)qualifierExpression).resolve();
        } else if (qualifierExpression instanceof GrMethodCall) {
            qResolved = ((GrMethodCall)qualifierExpression).resolveMethod();
        } else {
            return null;
        }
        String key = ref.getReferenceName();
        if (key == null) {
            return null;
        }
        for (GroovyMapContentProvider provider : (GroovyMapContentProvider[])GroovyMapContentProvider.EP_NAME.getExtensions()) {
            PsiType type = provider.getValueType(qualifierExpression, qResolved, key);
            if (type == null) continue;
            return type;
        }
        if (namedDomainCollectionType instanceof PsiClassReferenceType) {
            PsiClassReferenceType referenceType = (PsiClassReferenceType)namedDomainCollectionType;
            String fqName = TypesUtil.getQualifiedName((PsiType)referenceType);
            if ("org.gradle.api.tasks.SourceSetContainer".equals(fqName)) {
                GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)ref.getProject());
                return psiManager.createTypeByFQClassName("org.gradle.api.tasks.SourceSet", ref.getResolveScope());
            }
            if ("org.gradle.api.artifacts.ConfigurationContainer".equals(fqName)) {
                GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)ref.getProject());
                return psiManager.createTypeByFQClassName("org.gradle.api.artifacts.Configuration", ref.getResolveScope());
            }
            if ("org.gradle.api.tasks.TaskContainer".equals(fqName)) {
                GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)ref.getProject());
                return psiManager.createTypeByFQClassName("org.gradle.api.Task", ref.getResolveScope());
            }
        }
        return null;
    }
}

