/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.GradleSettingsControlProvider;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleProjectSettingsControl
extends AbstractExternalProjectSettingsControl<GradleProjectSettings> {
    private final GradleProjectSettingsControlBuilder myBuilder;

    public GradleProjectSettingsControl(GradleProjectSettings initialSettings) {
        this(GradleSettingsControlProvider.get().getProjectSettingsControlBuilder(initialSettings));
    }

    public GradleProjectSettingsControl(GradleProjectSettingsControlBuilder builder) {
        super(null, (ExternalProjectSettings)builder.getInitialSettings(), builder.getExternalSystemSettingsControlCustomizer());
        this.myBuilder = builder;
    }

    protected void fillExtraControls(PaintAwarePanel content, int indentLevel) {
        this.myBuilder.createAndFillControls(content, indentLevel);
    }

    public boolean validate(GradleProjectSettings settings) throws ConfigurationException {
        return this.myBuilder.validate(settings);
    }

    protected void applyExtraSettings(GradleProjectSettings settings) {
        this.myBuilder.apply(settings);
    }

    protected void updateInitialExtraSettings() {
        this.myBuilder.apply((GradleProjectSettings)this.getInitialSettings());
    }

    protected boolean isExtraSettingModified() {
        return this.myBuilder.isModified();
    }

    protected void resetExtraSettings(boolean isDefaultModuleCreation) {
        this.myBuilder.reset(this.getProject(), (GradleProjectSettings)this.getInitialSettings(), isDefaultModuleCreation);
    }

    public void update(String linkedProjectPath, boolean isDefaultModuleCreation) {
        this.myBuilder.update(linkedProjectPath, (GradleProjectSettings)this.getInitialSettings(), isDefaultModuleCreation);
    }

    public void showUi(boolean show) {
        super.showUi(show);
        this.myBuilder.showUi(show);
    }

    public void setCurrentProject(Project project) {
        super.setCurrentProject(project);
        this.myBuilder.reset(this.getProject(), (GradleProjectSettings)this.getInitialSettings(), false);
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myBuilder.disposeUIResources();
    }
}

