/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;

@State(name="GradleSystemSettings", storages={@Storage(file="$APP_CONFIG$/gradle.settings.xml")})
public class GradleSystemSettings
implements PersistentStateComponent<MyState> {
    private String myServiceDirectoryPath;
    private String myGradleVmOptions;
    private boolean myIsOfflineWork;

    public static GradleSystemSettings getInstance() {
        return (GradleSystemSettings)ServiceManager.getService(GradleSystemSettings.class);
    }

    public MyState getState() {
        MyState state = new MyState();
        state.serviceDirectoryPath = this.myServiceDirectoryPath;
        state.gradleVmOptions = this.myGradleVmOptions;
        state.offlineWork = this.myIsOfflineWork;
        return state;
    }

    public void loadState(MyState state) {
        this.myServiceDirectoryPath = state.serviceDirectoryPath;
        this.myGradleVmOptions = state.gradleVmOptions;
        this.myIsOfflineWork = state.offlineWork;
    }

    public String getServiceDirectoryPath() {
        return this.myServiceDirectoryPath;
    }

    public void setServiceDirectoryPath(String newPath) {
        this.myServiceDirectoryPath = newPath;
    }

    public String getGradleVmOptions() {
        return this.myGradleVmOptions;
    }

    public void setGradleVmOptions(String gradleVmOptions) {
        this.myGradleVmOptions = gradleVmOptions;
    }

    public boolean isOfflineWork() {
        return this.myIsOfflineWork;
    }

    public void setOfflineWork(boolean isOfflineWork) {
        this.myIsOfflineWork = isOfflineWork;
    }

    public static class MyState {
        public String serviceDirectoryPath;
        public String gradleVmOptions;
        public boolean offlineWork;
    }
}

