/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.cvsContext;

import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.cvsContext.CachedCvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsDataKeys;
import com.intellij.cvsSupport2.actions.cvsContext.CvsLightweightFile;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;

public class CvsContextWrapper
implements CvsContext {
    private final VcsContext myVcsContext;
    private final DataContext myContext;

    private CvsContextWrapper(AnActionEvent actionEvent, VcsContext vcsContext) {
        this.myContext = actionEvent.getDataContext();
        this.myVcsContext = vcsContext;
    }

    public static CvsContext createCachedInstance(AnActionEvent event) {
        return new CachedCvsContext(new CvsContextWrapper(event, VcsContextFactory.SERVICE.getInstance().createCachedContextOn(event)));
    }

    public static CvsContext createInstance(AnActionEvent event) {
        return new CvsContextWrapper(event, VcsContextFactory.SERVICE.getInstance().createContextOn(event));
    }

    @Override
    public boolean cvsIsActive() {
        Project project = this.getProject();
        if (project == null) {
            return false;
        }
        return ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)CvsVcs2.getInstance(project), this.getSelectedFiles());
    }

    public String getActionName() {
        return this.myVcsContext.getActionName();
    }

    @Override
    public Collection<String> getDeletedFileNames() {
        return (Collection)CvsDataKeys.DELETED_FILE_NAMES.getData(this.myContext);
    }

    @Override
    public CvsLightweightFile[] getSelectedLightweightFiles() {
        CvsLightweightFile[] files = (CvsLightweightFile[])CvsDataKeys.CVS_LIGHT_FILES.getData(this.myContext);
        if (files == null || files.length <= 0) {
            return null;
        }
        return files;
    }

    public Project getProject() {
        return this.myVcsContext.getProject();
    }

    public VirtualFile getSelectedFile() {
        return this.myVcsContext.getSelectedFile();
    }

    public VirtualFile[] getSelectedFiles() {
        return this.myVcsContext.getSelectedFiles();
    }

    public Editor getEditor() {
        return this.myVcsContext.getEditor();
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return this.myVcsContext.getSelectedFilesCollection();
    }

    public File[] getSelectedIOFiles() {
        return this.myVcsContext.getSelectedIOFiles();
    }

    public int getModifiers() {
        return this.myVcsContext.getModifiers();
    }

    public Refreshable getRefreshableDialog() {
        return this.myVcsContext.getRefreshableDialog();
    }

    public String getPlace() {
        return (String)this.myVcsContext.getPlace();
    }

    public File getSelectedIOFile() {
        return this.myVcsContext.getSelectedIOFile();
    }

    public FilePath[] getSelectedFilePaths() {
        return this.myVcsContext.getSelectedFilePaths();
    }

    public FilePath getSelectedFilePath() {
        return this.myVcsContext.getSelectedFilePath();
    }

    public ChangeList[] getSelectedChangeLists() {
        return this.myVcsContext.getSelectedChangeLists();
    }

    public Change[] getSelectedChanges() {
        return this.myVcsContext.getSelectedChanges();
    }
}

