/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.application;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.AddFileOrDirectoryAction;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextAdapter;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsStorageComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class AddHandler {
    private final Collection<VirtualFile> myAddedFiles = new ArrayList<VirtualFile>();
    private final Collection<VirtualFile> myAllFiles = new ArrayList<VirtualFile>();
    private final Collection<File> myIOFiles = new ArrayList<File>();
    private final Project myProject;
    private final CvsStorageComponent myCvsStorageComponent;

    public AddHandler(Project project, CvsStorageComponent cvsStorageComponent) {
        this.myProject = project;
        this.myCvsStorageComponent = cvsStorageComponent;
    }

    public void addFile(VirtualFile file) {
        this.myAllFiles.add(file);
    }

    public void addFile(File file) {
        this.myIOFiles.add(file);
    }

    public void execute() {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        CvsEntriesManager cvsEntriesManager = CvsEntriesManager.getInstance();
        for (VirtualFile file : this.myAllFiles) {
            if (changeListManager.isIgnoredFile(file) || !CvsUtil.fileIsUnderCvs(file.getParent())) continue;
            if (CvsUtil.fileIsLocallyRemoved(file)) {
                CvsUtil.restoreFile(file);
                continue;
            }
            if (CvsUtil.fileIsUnderCvs(file) || cvsEntriesManager.getCvsConnectionSettingsFor(file.getParent()).isOffline() || cvsEntriesManager.fileIsIgnored(file)) continue;
            this.myAddedFiles.add(file);
        }
        if (!this.myAddedFiles.isEmpty() && CvsVcs2.getInstance(this.myProject).getAddConfirmation().getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            Runnable addRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!AddHandler.this.myCvsStorageComponent.getIsActive()) {
                        return;
                    }
                    AddFileOrDirectoryAction.createActionToAddNewFileAutomatically().actionPerformed(AddHandler.this.createDataContext(AddHandler.this.myAddedFiles));
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                addRunnable.run();
            } else {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)addRunnable, null, (Project)this.myProject);
            }
        }
    }

    private CvsContext createDataContext(final Collection<VirtualFile> files) {
        final Iterator<VirtualFile> first = files.iterator();
        return new CvsContextAdapter(){

            @Override
            public Project getProject() {
                return AddHandler.this.myProject;
            }

            @Override
            public VirtualFile getSelectedFile() {
                return first.hasNext() ? (VirtualFile)first.next() : null;
            }

            @Override
            public VirtualFile[] getSelectedFiles() {
                return VfsUtil.toVirtualFileArray((Collection)files);
            }
        };
    }
}

