/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.ChildrenLoader;
import com.intellij.cvsSupport2.cvsBrowser.Cvs2Renderer;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsElementFactory;
import com.intellij.cvsSupport2.cvsBrowser.GetContentCallback;
import com.intellij.cvsSupport2.cvsBrowser.LoadingNode;
import com.intellij.cvsSupport2.cvsBrowser.ModuleDataProvider;
import com.intellij.cvsSupport2.cvsBrowser.RemoteResourceDataProvider;
import com.intellij.cvsSupport2.cvsBrowser.RootDataProvider;
import com.intellij.cvsSupport2.cvsBrowser.TreeNodeComparator;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContent;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsListenerWithProgress;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;

public class CvsTree
extends JPanel
implements CvsTabbedWindow.DeactivateListener,
ChildrenLoader<CvsElement> {
    private CvsElement[] myCurrentSelection = CvsElement.EMPTY_ARRAY;
    private Tree myTree;
    private DefaultTreeModel myModel;
    private CvsRootConfiguration myCvsRootConfiguration = null;
    private final Observable mySelectionObservable = new AlwaysNotifiedObservable();
    private final boolean myShowFiles;
    private final Consumer<VcsException> myErrorCallback;
    private final boolean myAllowRootSelection;
    private final boolean myShowModules;
    private final Project myProject;
    @JdkConstants.TreeSelectionMode
    private final int mySelectionMode;
    private final LoadingNode.Manager myLoadingNodeManager = new LoadingNode.Manager();
    @NonNls
    public static final String SELECTION_CHANGED = "Selection Changed";
    private final List<CvsTabbedWindow.DeactivateListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public CvsTree(Project project, boolean allowRootSelection, @JdkConstants.TreeSelectionMode int selectionMode, boolean showModules, boolean showFiles, Consumer<VcsException> errorCallback) {
        super(new BorderLayout());
        this.myProject = project;
        this.mySelectionMode = selectionMode;
        this.myShowModules = showModules;
        this.myAllowRootSelection = allowRootSelection;
        this.myShowFiles = showFiles;
        this.myErrorCallback = errorCallback;
        this.setSize(500, 500);
        this.addListener(this.myLoadingNodeManager);
    }

    private void addSelectionListener() {
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CvsTree.this.setCurrentSelection(CvsTree.this.myTree.getSelectionPaths());
            }
        });
    }

    public void setCvsRootConfiguration(CvsRootConfiguration cvsRootConfiguration) {
        if (cvsRootConfiguration.equals(this.myCvsRootConfiguration)) {
            return;
        }
        this.myCvsRootConfiguration = cvsRootConfiguration;
        TreeNode root = this.createRoot(this.myProject);
        this.myModel.setRoot(root);
    }

    private void setCurrentSelection(TreePath[] paths) {
        ArrayList<CvsElement> selection = new ArrayList<CvsElement>();
        if (paths != null) {
            for (TreePath path : paths) {
                CvsElement cvsElement;
                Object selectedObject = path.getLastPathComponent();
                if (!(selectedObject instanceof CvsElement) || (cvsElement = (CvsElement)selectedObject).getElementPath().equals(".") && !this.myAllowRootSelection) continue;
                selection.add(cvsElement);
            }
        }
        this.myCurrentSelection = selection.toArray(new CvsElement[selection.size()]);
        this.mySelectionObservable.notifyObservers(SELECTION_CHANGED);
    }

    private TreeNode createRoot(Project project) {
        if (this.myCvsRootConfiguration == null) {
            return new DefaultMutableTreeNode();
        }
        String rootName = this.myCvsRootConfiguration.toString();
        CvsElement result = CvsElementFactory.FOLDER_ELEMENT_FACTORY.createElement(rootName, this.myCvsRootConfiguration, project);
        result.setDataProvider(new RootDataProvider(this.myCvsRootConfiguration));
        result.setPath(".");
        result.cannotBeCheckedOut();
        result.setChildrenLoader(this);
        return result;
    }

    public CvsElement[] getCurrentSelection() {
        return this.myCurrentSelection;
    }

    public void selectRoot() {
        this.myTree.setSelectionPath(this.myTree.getPathForRow(0));
    }

    public void addSelectionObserver(Observer observer) {
        this.mySelectionObservable.addObserver(observer);
    }

    public Tree getTree() {
        return this.myTree;
    }

    public void init() {
        TreeNode root = this.createRoot(this.myProject);
        this.myModel = new DefaultTreeModel(root, true);
        this.myTree = new Tree((TreeModel)this.myModel);
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
        this.myTree.getSelectionModel().setSelectionMode(this.mySelectionMode);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new Cvs2Renderer()));
        this.addSelectionListener();
        TreeUIHelper uiHelper = TreeUIHelper.getInstance();
        uiHelper.installTreeSpeedSearch((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CvsTabbedWindow.DeactivateListener listener) {
        List<CvsTabbedWindow.DeactivateListener> list = this.myListeners;
        synchronized (list) {
            if (!this.myListeners.contains(listener)) {
                this.myListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CvsTabbedWindow.DeactivateListener listener) {
        List<CvsTabbedWindow.DeactivateListener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivated() {
        this.mySelectionObservable.deleteObservers();
        List<CvsTabbedWindow.DeactivateListener> list = this.myListeners;
        synchronized (list) {
            for (CvsTabbedWindow.DeactivateListener listener : this.myListeners) {
                listener.deactivated();
            }
            this.myListeners.clear();
        }
    }

    @Override
    public void loadChildren(final CvsElement element) {
        element.setLoading(true);
        this.myLoadingNodeManager.addTo(this.myModel, element);
        Application application = ApplicationManager.getApplication();
        final ModalityState modalityState = application.getCurrentModalityState();
        application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                RemoteResourceDataProvider dataProvider = element.getDataProvider();
                dataProvider.fillContentFor(new MyGetContentCallback(element, modalityState, CvsTree.this.myProject), (Consumer<VcsException>)CvsTree.this.myErrorCallback);
            }
        });
    }

    private class MyGetContentCallback
    implements GetContentCallback,
    CvsTabbedWindow.DeactivateListener {
        private final CvsElement myParentNode;
        private final ModalityState myModalityState;
        private final Project myProject;
        private CvsListenerWithProgress myListener;
        private long timeStamp = 0L;
        private int waitTime = 100;
        private TreePath mySelectionPath;

        public MyGetContentCallback(CvsElement parentNode, ModalityState modalityState, Project project) {
            this.myParentNode = parentNode;
            this.myModalityState = modalityState;
            this.myProject = project;
            CvsTree.this.addListener(this);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyGetContentCallback.this.mySelectionPath = CvsTree.this.myTree.getSelectionPath();
                    if (MyGetContentCallback.this.mySelectionPath == null) {
                        CvsTree.this.selectRoot();
                        MyGetContentCallback.this.mySelectionPath = CvsTree.this.myTree.getSelectionPath();
                    }
                }
            }, this.myModalityState);
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }

        @Override
        public String getElementPath() {
            return this.myParentNode.getElementPath();
        }

        @Override
        public ModalityState getModalityState() {
            return this.myModalityState;
        }

        @Override
        public void deactivated() {
            if (this.myListener != null) {
                this.myListener.indirectCancel();
            }
        }

        @Override
        public void useForCancel(CvsListenerWithProgress listener) {
            this.myListener = listener;
        }

        @Override
        public void appendDirectoryContent(final DirectoryContent directoryContent) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    long currentTime;
                    TreePath selectionPath = CvsTree.this.myTree.getSelectionPath();
                    if (selectionPath != null) {
                        MyGetContentCallback.this.mySelectionPath = selectionPath;
                    }
                    if (CvsTree.this.myShowModules) {
                        MyGetContentCallback.this.process(directoryContent.getSubModulesRaw(), CvsElementFactory.MODULE_ELEMENT_FACTORY, new ModuleDataProvider(CvsTree.this.myCvsRootConfiguration));
                    }
                    MyGetContentCallback.this.process(directoryContent.getSubDirectoriesRaw(), CvsElementFactory.FOLDER_ELEMENT_FACTORY, MyGetContentCallback.this.myParentNode.getDataProvider().getChildrenDataProvider());
                    if (CvsTree.this.myShowFiles) {
                        MyGetContentCallback.this.process(directoryContent.getFilesRaw(), CvsElementFactory.FILE_ELEMENT_FACTORY, RemoteResourceDataProvider.NOT_EXPANDABLE);
                    }
                    if (CvsTree.this.myTree.getSelectionPath() == null) {
                        CvsTree.this.myTree.setSelectionPath(MyGetContentCallback.this.mySelectionPath);
                    }
                    if ((currentTime = System.currentTimeMillis()) - MyGetContentCallback.this.timeStamp > (long)MyGetContentCallback.this.waitTime) {
                        MyGetContentCallback.this.waitTime += 100;
                        CvsTree.this.myModel.reload(MyGetContentCallback.this.myParentNode);
                        MyGetContentCallback.this.timeStamp = System.currentTimeMillis();
                    }
                }
            }, this.myModalityState);
        }

        protected void process(Collection<String> children, CvsElementFactory elementFactory, RemoteResourceDataProvider dataProvider) {
            for (String name : children) {
                CvsElement element = elementFactory.createElement(name, CvsTree.this.myCvsRootConfiguration, this.myProject);
                element.setDataProvider(dataProvider);
                element.setPath(this.myParentNode.createPathForChild(name));
                element.setChildrenLoader(CvsTree.this);
                this.myParentNode.insertSorted(element, TreeNodeComparator.INSTANCE);
            }
        }

        @Override
        public void finished() {
            CvsTree.this.removeListener(this);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CvsTree.this.myLoadingNodeManager.removeFrom(MyGetContentCallback.this.myParentNode);
                    MyGetContentCallback.this.myParentNode.setLoading(false);
                    if (MyGetContentCallback.this.mySelectionPath != null) {
                        if (MyGetContentCallback.this.mySelectionPath.getLastPathComponent() instanceof LoadingNode) {
                            TreeNode firstChild = MyGetContentCallback.this.myParentNode.getFirstChild();
                            CvsTree.this.myTree.setSelectionPath(MyGetContentCallback.this.mySelectionPath.getParentPath().pathByAddingChild(firstChild));
                        } else if (CvsTree.this.myTree.getSelectionPath() == null) {
                            CvsTree.this.myTree.setSelectionPath(MyGetContentCallback.this.mySelectionPath);
                        }
                    }
                }
            }, this.myModalityState);
        }
    }

    private static class AlwaysNotifiedObservable
    extends Observable {
        private AlwaysNotifiedObservable() {
        }

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    }
}

