/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsAdd;

import com.intellij.cvsSupport2.application.CvsStorageComponent;
import com.intellij.cvsSupport2.application.CvsStorageSupportingDeletionComponent;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionListWithSelection;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class AddedFileInfo
extends DefaultMutableTreeNode {
    private final VirtualFile myAddedFile;
    private final KeywordSubstitutionListWithSelection mySubstitution;
    private boolean myIncluded = true;
    private AddedFileInfo myParent;
    private final MyComparator myComparator = new MyComparator();
    private final Project myProject;
    private final MyObservable myExcludedObservable = new MyObservable();

    public AddedFileInfo(VirtualFile addedFile, Project project, CvsConfiguration config) {
        this.myAddedFile = addedFile;
        this.mySubstitution = KeywordSubstitutionListWithSelection.createOnFile(this.myAddedFile, config);
        this.myProject = project;
    }

    public KeywordSubstitution getKeywordSubstitution() {
        if (this.myAddedFile.isDirectory()) {
            return null;
        }
        return ((KeywordSubstitutionWrapper)this.mySubstitution.getSelection()).getSubstitution();
    }

    public VirtualFile getFile() {
        return this.myAddedFile;
    }

    public boolean included() {
        return this.myIncluded;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setIncluded(boolean included) {
        if (this.myIncluded == included) {
            return;
        }
        this.myIncluded = included;
        this.setIncludedChildren(this.myIncluded);
        if (this.myIncluded) {
            this.includeAllParents();
        }
        this.myExcludedObservable.setChanged();
        this.myExcludedObservable.notifyObservers();
    }

    private void includeAllParents() {
        if (this.myParent != null) {
            this.myParent.setIncluded(true);
        }
    }

    private void setIncludedChildren(boolean included) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((AddedFileInfo)this.getChildAt(i)).setIncluded(included);
        }
    }

    public void setParent(AddedFileInfo parent) {
        this.myParent = parent;
        this.myParent.add(this);
    }

    public String getPresentableText() {
        if (this.myParent == null) {
            return VcsPathPresenter.getInstance((Project)this.myProject).getPresentableRelativePathFor(this.myAddedFile);
        }
        return this.myAddedFile.getName();
    }

    public Icon getIcon() {
        if (this.myAddedFile.isDirectory()) {
            return AllIcons.Nodes.Folder;
        }
        return IconUtil.getIcon((VirtualFile)this.myAddedFile, (int)0, (Project)this.myProject);
    }

    public Collection<AddedFileInfo> collectAllIncludedFiles() {
        ArrayList<AddedFileInfo> result = new ArrayList<AddedFileInfo>();
        if (!this.myIncluded) {
            return result;
        }
        result.add(this);
        for (int i = 0; i < this.getChildCount(); ++i) {
            result.addAll(((AddedFileInfo)this.getChildAt(i)).collectAllIncludedFiles());
        }
        return result;
    }

    public void sort() {
        if (this.children == null) {
            return;
        }
        Collections.sort(this.children, this.myComparator);
        for (Object aChildren : this.children) {
            ((AddedFileInfo)aChildren).sort();
        }
    }

    public KeywordSubstitutionListWithSelection getKeywordSubstitutionsWithSelection() {
        return this.mySubstitution;
    }

    public void setKeywordSubstitution(KeywordSubstitution s) {
        this.mySubstitution.select(KeywordSubstitutionWrapper.getValue(s));
    }

    public File getPresentableFile() {
        return new File(this.getPresentableText());
    }

    public void addIncludedObserver(Observer observer) {
        this.myExcludedObservable.addObserver(observer);
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((AddedFileInfo)this.getChildAt(i)).addIncludedObserver(observer);
        }
    }

    public void removeIncludedObserver(Observer observer) {
        this.myExcludedObservable.deleteObserver(observer);
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((AddedFileInfo)this.getChildAt(i)).removeIncludedObserver(observer);
        }
    }

    public boolean hasIncludedNodes() {
        if (this.myIncluded) {
            return true;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            AddedFileInfo child = (AddedFileInfo)this.getChildAt(i);
            if (!child.hasIncludedNodes()) continue;
            return true;
        }
        return false;
    }

    public void clearAllCvsAdminDirectoriesInIncludedDirectories() {
        if (!this.myIncluded) {
            return;
        }
        if (!this.myAddedFile.isDirectory()) {
            return;
        }
        CvsStorageComponent cvsStorageComponent = CvsStorageSupportingDeletionComponent.getInstance(this.myProject);
        cvsStorageComponent.deleteIfAdminDirCreated(this.myAddedFile);
    }

    private static class MyObservable
    extends Observable {
        private MyObservable() {
        }

        @Override
        public synchronized void setChanged() {
            super.setChanged();
        }
    }

    private static class MyComparator
    implements Comparator {
        private MyComparator() {
        }

        public int compare(Object o1, Object o2) {
            AddedFileInfo info1 = (AddedFileInfo)o1;
            AddedFileInfo info2 = (AddedFileInfo)o2;
            if (info1.getFile().isDirectory() && !info2.getFile().isDirectory()) {
                return -1;
            }
            if (!info1.getFile().isDirectory() && info2.getFile().isDirectory()) {
                return 1;
            }
            return info1.getPresentableText().compareTo(info2.getPresentableText());
        }
    }
}

