/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsMessages;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.cvsoperations.common.UpdatedFilesManager;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.update.UpdateFileInfo;
import org.netbeans.lib.cvsclient.command.update.UpdatedFileInfo;

public class FileMessage {
    public static final int UNKNOWN = -1;
    public static final int SCHEDULING_FOR_ADDING = 0;
    public static final int SCHEDULING_FOR_REMOVING = 1;
    public static final int UPDATING = 2;
    public static final int IMPORTING = 3;
    public static final int ADDING = 4;
    public static final int REMOVING = 5;
    public static final int SAVING = 6;
    public static final int SENDING = 7;
    public static final int MODIFIED = 8;
    public static final int MERGED_WITH_CONFLICTS = 9;
    public static final int NOT_IN_REPOSITORY = 10;
    public static final int LOCALLY_ADDED = 11;
    public static final int LOCALLY_REMOVED = 12;
    public static final int REMOVED_FROM_REPOSITORY = 13;
    public static final int PATCHED = 14;
    public static final int UPDATING2 = 15;
    public static final int MERGED = 16;
    public static final int REMOVED_FROM_SERVER_CONFLICT = 17;
    public static final int LOCALLY_REMOVED_CONFLICT = 18;
    public static final int CREATED = 19;
    public static final int CREATED_BY_SECOND_PARTY = 20;
    private final int myType;
    private String myFileAbsolutePath = "";
    private CvsRevisionNumber myRevision;
    @NonNls
    public static final String CONFLICT = "C";
    @NonNls
    private static final String U_COMMIT_OPERATION_TYPE = "U";
    @NonNls
    private static final String P_COMMIT_OPERATION_TYPE = "P";
    @NonNls
    private static final String A_COMMIT_OPERATION_TYPE = "A";
    @NonNls
    private static final String R_COMMIT_OPERATION_TYPE = "R";
    @NonNls
    private static final String M_COMMIT_OPERATION_TYPE = "M";
    @NonNls
    private static final String Y_COMMIT_OPERATION_TYPE = "Y";

    public FileMessage(UpdateFileInfo info, UpdatedFilesManager mergedFilesCollector, UpdatedFilesManager updatedFilesManager) {
        Entry entry = info.getEntry();
        this.myType = FileMessage.getCommitOperationType(info.getType(), info.getFile(), entry, mergedFilesCollector, updatedFilesManager);
        this.myFileAbsolutePath = info.getFile().getAbsolutePath();
        if (entry != null) {
            this.myRevision = new CvsRevisionNumber(entry.getRevision());
        }
    }

    public FileMessage(UpdatedFileInfo info, UpdatedFilesManager updatedFilesManager) {
        Entry entry = info.getEntry();
        this.myType = FileMessage.getUpdateOperationType(info.getType(), info.getFile(), updatedFilesManager, entry);
        this.myFileAbsolutePath = info.getFile().getAbsolutePath();
        if (entry != null) {
            this.myRevision = new CvsRevisionNumber(entry.getRevision());
        }
    }

    public void showMessageIn(ProgressIndicator progress) {
        progress.setText2(this.getMyActionName() + ": " + this.myFileAbsolutePath);
    }

    private String getMyActionName() {
        switch (this.myType) {
            case 0: {
                return CvsBundle.message((String)"current.action.name.scheduling.for.adding", (Object[])new Object[0]);
            }
            case 1: {
                return CvsBundle.message((String)"current.action.name.scheduling.for.removing", (Object[])new Object[0]);
            }
            case 2: {
                return CvsBundle.message((String)"current.action.name.updating", (Object[])new Object[0]);
            }
            case 15: {
                return CvsBundle.message((String)"current.action.name.updating", (Object[])new Object[0]);
            }
            case 3: {
                return CvsBundle.message((String)"current.action.name.importing", (Object[])new Object[0]);
            }
            case 4: {
                return CvsBundle.message((String)"current.action.name.adding", (Object[])new Object[0]);
            }
            case 5: {
                return CvsBundle.message((String)"current.action.name.removing", (Object[])new Object[0]);
            }
            case 6: {
                return CvsBundle.message((String)"current.action.name.saving", (Object[])new Object[0]);
            }
            case 7: {
                return CvsBundle.message((String)"current.action.name.sending", (Object[])new Object[0]);
            }
            case 8: {
                return CvsBundle.message((String)"current.action.name.modified", (Object[])new Object[0]);
            }
        }
        return CvsBundle.message((String)"current.action.name.processing", (Object[])new Object[0]);
    }

    public String getFileAbsolutePath() {
        return this.myFileAbsolutePath;
    }

    public int getType() {
        return this.myType;
    }

    public CvsRevisionNumber getRevision() {
        return this.myRevision;
    }

    private static int getUpdateOperationType(UpdatedFileInfo.UpdatedType type, File file, UpdatedFilesManager updatedFilesManager, Entry entry) {
        if (type == UpdatedFileInfo.UpdatedType.REMOVED) {
            return 13;
        }
        VirtualFile virtualParent = CvsVfsUtil.getParentFor(file);
        if (virtualParent == null) {
            return 19;
        }
        if (type == UpdatedFileInfo.UpdatedType.MERGED) {
            if (entry.isConflict()) {
                return 9;
            }
            return 16;
        }
        if (updatedFilesManager.isNewlyCreatedEntryFor(virtualParent, file.getName())) {
            return 19;
        }
        return 2;
    }

    private static int getCommitOperationType(String commitOperationType, File file, Entry entry, UpdatedFilesManager mergedFiles, UpdatedFilesManager updatedFilesManager) {
        if (commitOperationType.equals(U_COMMIT_OPERATION_TYPE)) {
            VirtualFile virtualParent = CvsVfsUtil.getParentFor(file);
            if (virtualParent == null) {
                return 19;
            }
            if (updatedFilesManager.isNewlyCreatedEntryFor(virtualParent, file.getName())) {
                return 19;
            }
            return 2;
        }
        if (commitOperationType.equals(P_COMMIT_OPERATION_TYPE)) {
            return 14;
        }
        if (commitOperationType.equals(A_COMMIT_OPERATION_TYPE)) {
            return 11;
        }
        if (commitOperationType.equals(R_COMMIT_OPERATION_TYPE)) {
            return 12;
        }
        if (commitOperationType.equals(M_COMMIT_OPERATION_TYPE)) {
            if (mergedFiles.isMerged(file)) {
                return 16;
            }
            return 8;
        }
        if (commitOperationType.equals(CONFLICT)) {
            if (entry != null && entry.isResultOfMerge() || mergedFiles.isMerged(file)) {
                return 9;
            }
            if (mergedFiles.isCreatedBySecondParty(file)) {
                return 20;
            }
            if (CvsUtil.isLocallyRemoved(file)) {
                return 18;
            }
            return 17;
        }
        if (commitOperationType.equals(Y_COMMIT_OPERATION_TYPE)) {
            return 13;
        }
        if (commitOperationType.equals("?")) {
            return 10;
        }
        return -1;
    }
}

