/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.history;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.history.ComparableVcsRevisionOnOperation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileContent;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.IOException;

public abstract class CvsFileContent
implements VcsFileContent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.history.CvsFileContent");
    protected final ComparableVcsRevisionOnOperation myComparableCvsRevisionOnOperation;

    protected CvsFileContent(ComparableVcsRevisionOnOperation comparableCvsRevisionOnOperation) {
        this.myComparableCvsRevisionOnOperation = comparableCvsRevisionOnOperation;
    }

    public boolean isDeleted() {
        return this.myComparableCvsRevisionOnOperation.isDeleted();
    }

    public boolean isLoaded() {
        return this.myComparableCvsRevisionOnOperation.isLoaded();
    }

    public byte[] getContent() throws IOException, VcsException {
        if (!this.isLoaded()) {
            return null;
        }
        return this.myComparableCvsRevisionOnOperation.getContent();
    }

    public abstract VcsRevisionNumber getRevisionNumber();

    public byte[] loadContent() throws IOException, VcsException {
        this.myComparableCvsRevisionOnOperation.loadContent();
        if (!this.isLoaded()) {
            throw new VcsException(CvsBundle.message((String)"exception.text.cannot.load.revision", (Object[])new Object[]{this.getRevisionNumber()}));
        }
        if (this.fileNotFound()) {
            throw new VcsException(CvsBundle.message((String)"exception.text.cannot.find.revision", (Object[])new Object[]{this.getRevisionNumber()}));
        }
        if (this.isDeleted()) {
            throw new VcsException(CvsBundle.message((String)"message.text.revision.was.deleted.from.repository", (Object[])new Object[]{this.getRevisionNumber()}));
        }
        return this.myComparableCvsRevisionOnOperation.getContent();
    }

    public boolean fileNotFound() {
        return this.myComparableCvsRevisionOnOperation.fileNotFound();
    }
}

