/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.history;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetFileContentOperation;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.SimpleRevision;
import com.intellij.cvsSupport2.history.ComparableVcsRevisionOnOperation;
import com.intellij.cvsSupport2.history.CvsFileContent;
import com.intellij.cvsSupport2.history.CvsFileRevision;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.Revision;
import org.netbeans.lib.cvsclient.command.log.SymbolicName;

public class CvsFileRevisionImpl
extends CvsFileContent
implements CvsFileRevision {
    private final Revision myCvsRevision;
    private final LogInformation myLogInformation;
    private Collection<String> myTags;

    public CvsFileRevisionImpl(Revision cvsRevision, File file, LogInformation logInfo, CvsEnvironment cvsRoot, Project project) {
        super(new ComparableVcsRevisionOnOperation(CvsFileRevisionImpl.createGetFileContentOperation(cvsRevision, file, cvsRoot), project));
        this.myCvsRevision = cvsRevision;
        this.myLogInformation = logInfo;
    }

    private static GetFileContentOperation createGetFileContentOperation(Revision cvsRevision, File cvsLightweightFile, CvsEnvironment cvsEnvironment) {
        String revisionNumber = cvsRevision != null ? cvsRevision.getNumber() : null;
        return new GetFileContentOperation(cvsLightweightFile, cvsEnvironment, new SimpleRevision(revisionNumber));
    }

    @Override
    public Collection<String> getBranches() {
        return this.getBranchList(true);
    }

    private Collection<String> getBranchList(boolean includeRevisionNumbers) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<SymbolicName> processedSymbolicNames = new HashSet<SymbolicName>();
        String branches = this.myCvsRevision.getBranches();
        if (branches != null && branches.length() != 0) {
            String[] branchNames;
            for (String branchName : branchNames = branches.split(";")) {
                CvsRevisionNumber revisionNumber = new CvsRevisionNumber(branchName.trim());
                List<SymbolicName> symNames = this.getSymbolicNames(revisionNumber);
                if (symNames.isEmpty()) continue;
                for (SymbolicName symName : symNames) {
                    processedSymbolicNames.add(symName);
                    if (includeRevisionNumbers) {
                        result.add(symName.getName() + " (" + revisionNumber.asString() + ")");
                        continue;
                    }
                    result.add(symName.getName());
                }
            }
        }
        List symNames = this.myLogInformation.getAllSymbolicNames();
        for (SymbolicName symName : symNames) {
            if (!StringUtil.startsWithConcatenation((String)symName.getRevision(), (String[])new String[]{this.myCvsRevision.getNumber(), "."}) || processedSymbolicNames.contains(symName)) continue;
            CvsRevisionNumber number = new CvsRevisionNumber(symName.getRevision().trim());
            int[] subRevisions = number.getSubRevisions();
            if (subRevisions.length == 4) {
                int lastSubRevision = subRevisions[subRevisions.length - 1];
                number = number.removeTailVersions(2);
                number = number.addTailVersions(new int[]{lastSubRevision});
            }
            if (includeRevisionNumbers) {
                result.add(symName.getName() + " (" + number.asString() + ")");
                continue;
            }
            result.add(symName.getName());
        }
        return result;
    }

    private List<SymbolicName> getSymbolicNames(CvsRevisionNumber revisionNumber) {
        CvsRevisionNumber symRevNumber;
        int[] subRevisions = revisionNumber.getSubRevisions();
        CvsRevisionNumber headRevNumber = revisionNumber.removeTailVersions(1);
        if (subRevisions != null && subRevisions.length > 1) {
            int lastSubRevision = subRevisions[subRevisions.length - 1];
            symRevNumber = headRevNumber.addTailVersions(new int[]{0, lastSubRevision});
        } else {
            symRevNumber = headRevNumber.addTailVersions(new int[]{0, 2});
        }
        return this.myLogInformation.getSymNamesForRevision(symRevNumber.asString());
    }

    public String getAuthor() {
        return this.myCvsRevision.getAuthor();
    }

    @Override
    public String getState() {
        return this.myCvsRevision.getState();
    }

    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    @Override
    public Collection<String> getTags() {
        if (this.myTags == null) {
            this.myTags = this.myLogInformation == null ? Collections.emptyList() : this.collectSymNamesForRevision();
        }
        return this.myTags;
    }

    private List<String> collectSymNamesForRevision() {
        ArrayList<String> result = new ArrayList<String>();
        List symNames = this.myLogInformation.getSymNamesForRevision(this.myCvsRevision.getNumber());
        for (SymbolicName symName : symNames) {
            result.add(symName.getName());
        }
        return result;
    }

    @Override
    public VcsRevisionNumber getRevisionNumber() {
        if (this.myCvsRevision != null) {
            return new CvsRevisionNumber(this.myCvsRevision.getNumber());
        }
        CvsRevisionNumber number = this.myComparableCvsRevisionOnOperation.getRevision();
        return number == null ? VcsRevisionNumber.NULL : number;
    }

    public Date getRevisionDate() {
        return this.myCvsRevision.getDate();
    }

    public String getCommitMessage() {
        return this.myCvsRevision.getMessage();
    }

    public String toString() {
        return this.getRevisionNumber().asString();
    }

    public String getBranchName() {
        return StringUtil.join(this.getBranchList(false), (String)", ");
    }
}

