/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.javacvsImpl.io;

import com.intellij.util.ArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineReader {
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private final byte[] myBuffer;
    private final InputStream myInputStream;
    private final ByteArrayOutputStream myOutputStream = new ByteArrayOutputStream();
    private int myBytesExpected;
    private int myPosition = 0;
    private int myBytesBuffered = 0;
    private int myLastEol = 0;

    public LineReader(InputStream in, int bytesExpected) {
        this(in, bytesExpected, 10240);
    }

    public LineReader(InputStream in, int bytesExpected, int bufferSize) {
        if (bufferSize < 2) {
            throw new IllegalArgumentException("buffer size must be greater than 1");
        }
        this.myInputStream = in;
        this.myBytesExpected = bytesExpected;
        this.myBuffer = new byte[bufferSize];
    }

    private void fillBuffer() throws IOException {
        if (this.myBytesExpected == 0) {
            this.myBytesBuffered = -1;
            return;
        }
        this.myBytesBuffered = this.myInputStream.read(this.myBuffer, 0, Math.min(this.myBuffer.length, this.myBytesExpected));
        if (this.myBytesBuffered > 0) {
            this.myBytesExpected -= this.myBytesBuffered;
            this.myPosition = 0;
        }
    }

    private byte[] getLineArray() {
        ++this.myPosition;
        if (this.myOutputStream.size() == 0) {
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = this.myOutputStream.toByteArray();
        this.myOutputStream.reset();
        return bytes;
    }

    public byte[] readLine() throws IOException {
        if (this.myBytesBuffered == -1) {
            if (this.myLastEol != 0) {
                this.myLastEol = 0;
                return this.getLineArray();
            }
            return null;
        }
        if (this.myPosition >= this.myBytesBuffered) {
            this.fillBuffer();
            if (this.myBytesBuffered == -1) {
                return this.getLineArray();
            }
        }
        byte[] buffer = this.myBuffer;
        while (this.myBytesBuffered != -1) {
            while (this.myPosition < this.myBytesBuffered) {
                byte c = buffer[this.myPosition];
                switch (c) {
                    case 13: {
                        if (this.myLastEol == 13) {
                            return this.getLineArray();
                        }
                        this.myLastEol = 13;
                        break;
                    }
                    case 10: {
                        if (this.myLastEol == 10) {
                            return this.getLineArray();
                        }
                        this.myLastEol = 10;
                        break;
                    }
                    default: {
                        if (this.myLastEol != 0) {
                            this.myLastEol = 0;
                            byte[] line = this.getLineArray();
                            this.myOutputStream.write(c);
                            return line;
                        }
                        this.myOutputStream.write(c);
                    }
                }
                ++this.myPosition;
            }
            this.fillBuffer();
        }
        return this.getLineArray();
    }
}

