/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.updateinfo;

import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesAdapter;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.FileMessage;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.netbeans.lib.cvsclient.admin.Entry;

public class UpdatedFilesProcessor
extends CvsMessagesAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.updateinfo.UpdatedFilesProcessor");
    private final UpdatedFiles myUpdatedFiles;

    public UpdatedFilesProcessor(UpdatedFiles updatedFiles) {
        this.myUpdatedFiles = updatedFiles;
    }

    @Override
    public void addFileMessage(FileMessage message) {
        String path = message.getFileAbsolutePath();
        VirtualFile virtualFile = UpdatedFilesProcessor.getVirtualFileFor(path);
        int messageType = message.getType();
        if (virtualFile != null && messageType == 10 && FileTypeManager.getInstance().isFileIgnored(virtualFile)) {
            return;
        }
        FileGroup collection = this.getCollectionFor(messageType, virtualFile);
        LOG.assertTrue(collection != null, (Object)String.valueOf(messageType));
        CvsRevisionNumber revision = message.getRevision();
        collection.add(path, CvsVcs2.getKey(), (VcsRevisionNumber)revision);
    }

    private FileGroup getCollectionFor(int messageType, VirtualFile vFile) {
        switch (messageType) {
            case 8: {
                return this.myUpdatedFiles.getGroupById("MODIFIED");
            }
            case 16: {
                return this.getMergedFileGroup(vFile, "MERGED");
            }
            case 9: {
                return this.getMergedFileGroup(vFile, "MERGED_WITH_CONFLICTS");
            }
            case 20: {
                return this.myUpdatedFiles.getGroupById("CREATED_BY_SECOND_PARTY");
            }
            case 10: {
                return this.myUpdatedFiles.getGroupById("UNKNOWN");
            }
            case 11: {
                return this.myUpdatedFiles.getGroupById("LOCALLY_ADDED");
            }
            case 12: {
                return this.myUpdatedFiles.getGroupById("LOCALLY_REMOVED");
            }
            case 13: {
                return this.myUpdatedFiles.getGroupById("REMOVED_FROM_REPOSITORY");
            }
            case 19: {
                return this.myUpdatedFiles.getGroupById("CREATED");
            }
            case 2: {
                if (vFile == null) {
                    return this.myUpdatedFiles.getGroupById("RESTORED");
                }
                return this.myUpdatedFiles.getGroupById("UPDATED");
            }
            case 14: {
                return this.myUpdatedFiles.getGroupById("UPDATED");
            }
            case 17: {
                return this.myUpdatedFiles.getGroupById("MOD_REMOVED_FROM_SERVER");
            }
            case 18: {
                return this.myUpdatedFiles.getGroupById("LOCALLY_REMOVED_MODIFIED_ON_SERVER");
            }
        }
        return this.myUpdatedFiles.getGroupById("UNKNOWN");
    }

    private FileGroup getMergedFileGroup(VirtualFile vFile, String textMergedId) {
        Entry entry;
        if (vFile != null && (entry = CvsEntriesManager.getInstance().getEntryFor(vFile)) != null && entry.isBinary()) {
            return this.myUpdatedFiles.getGroupById("BINARY_MERGED");
        }
        return this.myUpdatedFiles.getGroupById(textMergedId);
    }

    public static VirtualFile getVirtualFileFor(String path) {
        if (path == null) {
            return null;
        }
        return CvsVfsUtil.findFileByPath(path.replace(File.separatorChar, '/'));
    }
}

