/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class CvsVfsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.util.CvsVfsUtil");

    public static VirtualFile findFileByPath(String path) {
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    public static VirtualFile findChild(VirtualFile file, String name) {
        if (file == null) {
            return LocalFileSystem.getInstance().findFileByIoFile(new File(name));
        }
        return file.findChild(name);
    }

    public static VirtualFile getParentFor(File file) {
        return CvsVfsUtil.findFileByIoFile(file.getParentFile());
    }

    public static File getFileFor(VirtualFile file) {
        if (file == null) {
            return null;
        }
        return new File(file.getPath());
    }

    public static File getFileFor(VirtualFile parent, String name) {
        if (parent == null) {
            return new File(name);
        }
        return new File(parent.getPath(), name);
    }

    public static VirtualFile findFileByIoFile(File file) {
        if (file == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public static VirtualFile refreshAndFindFileByIoFile(File file) {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    public static VirtualFile[] getChildrenOf(VirtualFile directory) {
        if (!directory.isValid()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] children = directory.getChildren();
        return children == null ? VirtualFile.EMPTY_ARRAY : children;
    }

    public static long getTimeStamp(VirtualFile file) {
        return file.getTimeStamp();
    }

    public static boolean isWritable(VirtualFile virtualFile) {
        return virtualFile.isWritable();
    }

    public static String getPresentablePathFor(VirtualFile root) {
        return root.getPresentableUrl();
    }

    public static VirtualFile refreshAndfFindChild(VirtualFile parent, String fileName) {
        return CvsVfsUtil.refreshAndFindFileByIoFile(new File(CvsVfsUtil.getFileFor(parent), fileName));
    }
}

