/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.codehaus.plexus.component.configurator.converters.basic;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gradle.mvn3.org.codehaus.plexus.component.configurator.converters.basic.AbstractBasicConverter;

public class DateConverter
extends AbstractBasicConverter {
    private static final DateFormat[] formats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S a"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ssa")};

    public boolean canConvert(Class type) {
        return type.equals(Date.class);
    }

    public Object fromString(String str) {
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(str);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    public String toString(Object obj) {
        Date date = (Date)obj;
        return formats[0].format(date);
    }
}

