/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.codehaus.plexus.component.discovery;

import java.io.Reader;
import java.util.Arrays;
import org.gradle.mvn3.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.gradle.mvn3.org.codehaus.plexus.component.discovery.AbstractResourceBasedComponentDiscoverer;
import org.gradle.mvn3.org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.gradle.mvn3.org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.gradle.mvn3.org.codehaus.plexus.component.repository.io.PlexusTools;
import org.gradle.mvn3.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.gradle.mvn3.org.codehaus.plexus.configuration.PlexusConfigurationException;

public class PlexusXmlComponentDiscoverer
extends AbstractResourceBasedComponentDiscoverer {
    public String getComponentDescriptorLocation() {
        return "META-INF/plexus/plexus.xml";
    }

    protected ComponentSetDescriptor createComponentDescriptors(Reader reader, String source, ClassRealm realm) throws PlexusConfigurationException {
        ComponentSetDescriptor componentSetDescriptor = new ComponentSetDescriptor();
        PlexusConfiguration configuration = PlexusTools.buildConfiguration(source, reader);
        if (configuration != null) {
            PlexusConfiguration[] componentConfigurations;
            for (PlexusConfiguration componentConfiguration : componentConfigurations = configuration.getChild("components").getChildren("component")) {
                ComponentDescriptor<?> componentDescriptor;
                try {
                    componentDescriptor = PlexusTools.buildComponentDescriptor(componentConfiguration, realm);
                    if (componentDescriptor == null) {
                        continue;
                    }
                }
                catch (PlexusConfigurationException e) {
                    throw new PlexusConfigurationException("Cannot build component descriptor from resource found in:\n" + Arrays.asList(realm.getURLs()), e);
                }
                componentDescriptor.setComponentType("plexus");
                componentDescriptor.setComponentSetDescriptor(componentSetDescriptor);
                componentSetDescriptor.addComponentDescriptor(componentDescriptor);
            }
        }
        return componentSetDescriptor;
    }
}

