/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.codehaus.plexus.configuration.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.gradle.mvn3.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.gradle.mvn3.org.codehaus.plexus.configuration.io.PlexusConfigurationWriter;

public class XmlPlexusConfigurationWriter
implements PlexusConfigurationWriter {
    public void write(OutputStream outputStream, PlexusConfiguration configuration) throws IOException {
        this.write(new OutputStreamWriter(outputStream), configuration);
    }

    public void write(Writer writer, PlexusConfiguration configuration) throws IOException {
        int depth = 0;
        this.display(configuration, writer, depth);
    }

    private void display(PlexusConfiguration c, Writer w, int depth) throws IOException {
        int count = c.getChildCount();
        if (count == 0) {
            this.displayTag(c, w, depth);
        } else {
            this.indent(depth, w);
            w.write(60);
            w.write(c.getName());
            this.attributes(c, w);
            w.write(62);
            w.write(10);
            for (int i = 0; i < count; ++i) {
                PlexusConfiguration child = c.getChild(i);
                this.display(child, w, depth + 1);
            }
            this.indent(depth, w);
            w.write(60);
            w.write(47);
            w.write(c.getName());
            w.write(62);
            w.write(10);
        }
    }

    private void displayTag(PlexusConfiguration c, Writer w, int depth) throws IOException {
        String value = c.getValue(null);
        if (value != null) {
            this.indent(depth, w);
            w.write(60);
            w.write(c.getName());
            this.attributes(c, w);
            w.write(62);
            w.write(c.getValue(null));
            w.write(60);
            w.write(47);
            w.write(c.getName());
            w.write(62);
            w.write(10);
        } else {
            this.indent(depth, w);
            w.write(60);
            w.write(c.getName());
            this.attributes(c, w);
            w.write(47);
            w.write(62);
            w.write("\n");
        }
    }

    private void attributes(PlexusConfiguration c, Writer w) throws IOException {
        String[] names = c.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            w.write(32);
            w.write(names[i]);
            w.write(61);
            w.write(34);
            w.write(c.getAttribute(names[i], null));
            w.write(34);
        }
    }

    private void indent(int depth, Writer w) throws IOException {
        for (int i = 0; i < depth; ++i) {
            w.write(32);
        }
    }
}

