/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import javax.tools.JavaCompiler;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.reflect.DirectInstantiator;

public class JdkTools {
    private static final String DEFAULT_COMPILER_IMPL_NAME = "com.sun.tools.javac.api.JavacTool";
    private static final AtomicReference<JdkTools> INSTANCE = new AtomicReference();
    private final ClassLoader isolatedToolsLoader;

    public static JdkTools current() {
        JdkTools jdkTools = INSTANCE.get();
        if (jdkTools == null) {
            INSTANCE.compareAndSet(null, new JdkTools(Jvm.current()));
            jdkTools = INSTANCE.get();
        }
        return jdkTools;
    }

    JdkTools(JavaInfo javaInfo) {
        File toolsJar = javaInfo.getToolsJar();
        if (toolsJar == null) {
            throw new IllegalStateException("Could not find tools.jar");
        }
        this.isolatedToolsLoader = new DefaultClassLoaderFactory().createIsolatedClassLoader(new DefaultClassPath(toolsJar));
    }

    public JavaCompiler getSystemJavaCompiler() {
        Class<?> compilerImplClass;
        try {
            compilerImplClass = this.isolatedToolsLoader.loadClass(DEFAULT_COMPILER_IMPL_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load class 'com.sun.tools.javac.api.JavacTool' from " + Jvm.current().getToolsJar());
        }
        return DirectInstantiator.instantiate(compilerImplClass.asSubclass(JavaCompiler.class), new Object[0]);
    }
}

