/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.PostCompilationData;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.MergeResources;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.LibraryBundle;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.dependency.ManifestDependency;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class LibraryTaskManager
extends TaskManager {
    private static final String ANNOTATIONS = "annotations";
    private Task assembleDefault;

    public LibraryTaskManager(Project project, AndroidBuilder androidBuilder, AndroidConfig extension, SdkHandler sdkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry) {
        super(project, androidBuilder, extension, sdkHandler, dependencyManager, toolingRegistry);
    }

    @Override
    public void createTasksForVariantData(final @NonNull TaskFactory tasks, final @NonNull BaseVariantData<? extends BaseVariantOutputData> variantData) {
        final LibraryVariantData libVariantData = (LibraryVariantData)variantData;
        final GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        CoreBuildType buildType = (CoreBuildType)variantConfig.getBuildType();
        final VariantScope variantScope = variantData.getScope();
        final String dirName = variantConfig.getDirName();
        this.createAnchorTasks(tasks, variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createGenerateResValuesTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createMergeLibManifestsTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createRenderscriptTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        AndroidTask packageRes = (AndroidTask)ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, (Recorder.Block)new Recorder.Block<AndroidTask<MergeResources>>(){

            public AndroidTask<MergeResources> call() throws Exception {
                AndroidTask<MergeResources> mergeResourceTask = LibraryTaskManager.this.basicCreateMergeResourcesTask(tasks, variantScope, "package", new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + variantScope.getVariantConfiguration().getDirName() + "/res"), false, false);
                if (variantData.getVariantDependency().hasNonOptionalLibraries()) {
                    LibraryTaskManager.this.createMergeResourcesTask(tasks, variantScope);
                }
                mergeResourceTask.configure(tasks, new Action<Task>(){

                    public void execute(Task task) {
                        MergeResources mergeResourcesTask = (MergeResources)task;
                        mergeResourcesTask.setPublicFile(new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName + "/" + "public.txt"));
                    }
                });
                return mergeResourceTask;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                LibraryTaskManager.this.createMergeAssetsTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createBuildConfigTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_BACKPORT_RESOURCES_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createPreprocessResourcesTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_PROCESS_RES_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createProcessResTask(tasks, variantScope, new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName), false);
                LibraryTaskManager.this.createProcessJavaResTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_AIDL_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createAidlTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_COMPILE_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                AndroidTask<JavaCompile> javacTask = LibraryTaskManager.this.createJavacTask(tasks, variantScope);
                TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        final Sync packageJniLibs = (Sync)this.project.getTasks().create(variantScope.getTaskName("package", "JniLibs"), Sync.class);
        if (this.isNdkTaskNeeded) {
            ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_NDK_TASK, (Recorder.Block)new Recorder.Block<Void>(){

                public Void call() throws Exception {
                    LibraryTaskManager.this.createNdkTasks(variantScope);
                    packageJniLibs.dependsOn(new Object[]{variantData.ndkCompileTask});
                    packageJniLibs.from(new Object[]{variantData.ndkCompileTask.getSoFolder()}).include(new String[]{"**/*.so"});
                    return null;
                }
            }, new Recorder.Property[0]);
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(tasks, this.getNdkBuildable(variantData));
        }
        Sync packageRenderscript = (Sync)ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_PACKAGING_TASK, (Recorder.Block)new Recorder.Block<Sync>(){

            public Sync call() throws Exception {
                packageJniLibs.from(new Object[]{variantConfig.getJniLibsList()}).include(new String[]{"**/*.so"});
                packageJniLibs.into((Object)new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName + "/jni"));
                Sync packageRenderscript = (Sync)LibraryTaskManager.this.project.getTasks().create(variantScope.getTaskName("package", "Renderscript"), Sync.class);
                packageRenderscript.from(new Object[]{variantConfig.getRenderscriptSourceList()}).include(new String[]{"**/*.rsh"});
                packageRenderscript.into((Object)new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName + "/" + "rs"));
                return packageRenderscript;
            }
        }, new Recorder.Property[0]);
        MergeFileTask mergeProGuardFileTask = (MergeFileTask)((Object)ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_PROGUARD_FILE_TASK, (Recorder.Block)new Recorder.Block<MergeFileTask>(){

            public MergeFileTask call() throws Exception {
                MergeFileTask mergeProGuardFileTask = (MergeFileTask)LibraryTaskManager.this.project.getTasks().create(variantScope.getTaskName("merge", "ProguardFiles"), MergeFileTask.class);
                mergeProGuardFileTask.setInputFiles(LibraryTaskManager.this.project.files(new Object[]{variantConfig.getConsumerProguardFiles()}).getFiles());
                mergeProGuardFileTask.setOutputFile(new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName + "/" + "proguard.txt"));
                return mergeProGuardFileTask;
            }
        }, new Recorder.Property[0]));
        Copy lintCopy = (Copy)this.project.getTasks().create(variantScope.getTaskName("copy", "Lint"), Copy.class);
        lintCopy.dependsOn(new Object[]{"compileLint"});
        lintCopy.from(new Object[]{new File(variantScope.getGlobalScope().getIntermediatesDir(), "lint/lint.jar")});
        lintCopy.into((Object)new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName));
        Zip bundle = (Zip)this.project.getTasks().create(variantScope.getTaskName("bundle"), Zip.class);
        if (variantData.getVariantDependency().isAnnotationsPresent()) {
            libVariantData.generateAnnotationsTask = this.createExtractAnnotations(this.project, variantData);
        }
        if (libVariantData.generateAnnotationsTask != null) {
            bundle.dependsOn(new Object[]{libVariantData.generateAnnotationsTask});
        }
        final boolean instrumented = ((CoreBuildType)variantConfig.getBuildType()).isTestCoverageEnabled();
        final PostCompilationData pcDataTemp = new PostCompilationData();
        final PostCompilationData pcData = (PostCompilationData)ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_POST_COMPILATION_TASK, (Recorder.Block)new Recorder.Block<PostCompilationData>(){

            public PostCompilationData call() throws Exception {
                pcDataTemp.setClassGeneratingTasks(Collections.singletonList(variantScope.getJavacTask().getName()));
                pcDataTemp.setLibraryGeneratingTasks(Collections.singletonList(variantData.getVariantDependency().getPackageConfiguration().getBuildDependencies()));
                pcDataTemp.setInputFilesCallable(new Callable<List<File>>(){

                    @Override
                    public List<File> call() throws Exception {
                        return new ArrayList<File>(variantData.javacTask.getOutputs().getFiles().getFiles());
                    }
                });
                pcDataTemp.setInputDir(variantScope.getJavaOutputDir());
                pcDataTemp.setInputLibraries(Collections.<File>emptyList());
                if (instrumented) {
                    return LibraryTaskManager.this.createJacocoTask(tasks, variantScope, pcDataTemp);
                }
                return pcDataTemp;
            }
        }, new Recorder.Property[0]);
        Preconditions.checkState((pcData != null ? 1 : 0) != 0);
        if (buildType.isMinifyEnabled()) {
            ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_PROGUARD_TASK, (Recorder.Block)new Recorder.Block<Void>(){

                public Void call() throws Exception {
                    File outFile = LibraryTaskManager.this.maybeCreateProguardTasks(tasks, variantScope, pcData);
                    Preconditions.checkNotNull((Object)outFile);
                    pcData.setInputFiles(Collections.singletonList(outFile));
                    pcData.setInputDirCallable(null);
                    pcData.setInputLibraries(Collections.<File>emptyList());
                    return null;
                }
            }, new Recorder.Property[0]);
        } else {
            ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_PACKAGE_LOCAL_JAR, (Recorder.Block)new Recorder.Block<Void>(){

                public Void call() throws Exception {
                    Sync packageLocalJar = (Sync)LibraryTaskManager.this.project.getTasks().create(variantScope.getTaskName("package", "LocalJar"), Sync.class);
                    packageLocalJar.from(DependencyManager.getPackagedLocalJarFileList(variantData.getVariantDependency()).toArray());
                    packageLocalJar.into((Object)new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName + "/" + "libs"));
                    packageLocalJar.from(new Object[]{pcData.getInputLibrariesCallable()});
                    TaskManager.optionalDependsOn((Task)packageLocalJar, pcData.getLibraryGeneratingTasks());
                    pcData.setLibraryGeneratingTasks(Collections.singletonList(packageLocalJar));
                    Jar jar = (Jar)LibraryTaskManager.this.project.getTasks().create(variantScope.getTaskName("package", "Jar"), Jar.class);
                    jar.dependsOn(new Object[]{variantScope.getProcessJavaResourcesTask().getName()});
                    jar.from(new Object[]{pcData.getInputDirCallable()});
                    TaskManager.optionalDependsOn((Task)jar, pcData.getClassGeneratingTasks());
                    pcData.setClassGeneratingTasks(Collections.singletonList(jar));
                    jar.from(new Object[]{variantScope.getJavaResourcesDestinationDir()});
                    jar.setDestinationDir(new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName));
                    jar.setArchiveName("classes.jar");
                    String packageName = variantConfig.getPackageFromManifest();
                    if (packageName == null) {
                        throw new BuildException("Failed to read manifest", null);
                    }
                    packageName = packageName.replace(".", "/");
                    jar.exclude(new String[]{packageName + "/R.class"});
                    jar.exclude(new String[]{packageName + "/R$*.class"});
                    if (!LibraryTaskManager.this.getExtension().getPackageBuildConfig().booleanValue()) {
                        jar.exclude(new String[]{packageName + "/Manifest.class"});
                        jar.exclude(new String[]{packageName + "/Manifest$*.class"});
                        jar.exclude(new String[]{packageName + "/BuildConfig.class"});
                    }
                    if (libVariantData.generateAnnotationsTask != null) {
                        jar.dependsOn(new Object[]{libVariantData.generateAnnotationsTask});
                    }
                    return null;
                }
            }, new Recorder.Property[0]);
        }
        bundle.dependsOn(new Object[]{packageRes.getName(), packageRenderscript, lintCopy, packageJniLibs, mergeProGuardFileTask});
        TaskManager.optionalDependsOn((Task)bundle, pcData.getClassGeneratingTasks());
        TaskManager.optionalDependsOn((Task)bundle, pcData.getLibraryGeneratingTasks());
        bundle.setDescription("Assembles a bundle containing the library in " + variantConfig.getFullName() + ".");
        bundle.setDestinationDir(new File(variantScope.getGlobalScope().getOutputsDir(), "aar"));
        bundle.setArchiveName(this.project.getName() + "-" + variantConfig.getBaseName() + "." + "aar");
        bundle.setExtension("aar");
        bundle.from(new Object[]{new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName)});
        bundle.from(new Object[]{new File(variantScope.getGlobalScope().getIntermediatesDir(), "annotations/" + dirName)});
        LibVariantOutputData variantOutputData = (LibVariantOutputData)libVariantData.getOutputs().get(0);
        variantOutputData.packageLibTask = bundle;
        variantData.assembleVariantTask.dependsOn(new Object[]{bundle});
        variantOutputData.assembleTask = variantData.assembleVariantTask;
        if (this.getExtension().getDefaultPublishConfig().equals(variantConfig.getFullName())) {
            VariantHelper.setupDefaultConfig(this.project, variantData.getVariantDependency().getPackageConfiguration());
            this.project.getArtifacts().add("default", (Object)bundle);
            this.getAssembleDefault().dependsOn(new Object[]{variantData.assembleVariantTask});
        }
        if (this.getExtension().getPublishNonDefault()) {
            this.project.getArtifacts().add(variantData.getVariantDependency().getPublishConfiguration().getName(), (Object)bundle);
            bundle.setClassifier(variantData.getVariantDependency().getPublishConfiguration().getName());
        }
        variantConfig.setOutput((LibraryDependency)new LibraryBundle(bundle.getArchivePath(), new File(variantScope.getGlobalScope().getIntermediatesDir(), "bundles/" + dirName), variantData.getName(), this.project.getPath()){

            @Nullable
            public String getProjectVariant() {
                return variantData.getName();
            }

            @NonNull
            public List<LibraryDependency> getDependencies() {
                return variantConfig.getDirectLibraries();
            }

            @NonNull
            public List<? extends AndroidLibrary> getLibraryDependencies() {
                return variantConfig.getDirectLibraries();
            }

            @NonNull
            public List<? extends ManifestDependency> getManifestDependencies() {
                return variantConfig.getDirectLibraries();
            }

            @Nullable
            public MavenCoordinates getRequestedCoordinates() {
                return null;
            }

            @Nullable
            public MavenCoordinates getResolvedCoordinates() {
                return null;
            }

            @NonNull
            protected File getJarsRootFolder() {
                return this.getFolder();
            }

            public boolean isOptional() {
                return false;
            }
        });
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_LINT_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createLintTasks(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
    }

    public ExtractAnnotations createExtractAnnotations(final Project project, BaseVariantData variantData) {
        final GradleVariantConfiguration config = variantData.getVariantConfiguration();
        ExtractAnnotations task = (ExtractAnnotations)project.getTasks().create(variantData.getScope().getTaskName("extract", "Annotations"), ExtractAnnotations.class);
        task.setDescription("Extracts Android annotations for the " + variantData.getVariantConfiguration().getFullName() + " variant into the archive file");
        task.setGroup("build");
        task.variant = variantData;
        task.setDestinationDir(new File(variantData.getScope().getGlobalScope().getIntermediatesDir(), "annotations/" + config.getDirName()));
        task.output = new File(task.getDestinationDir(), "annotations.zip");
        task.classDir = new File(variantData.getScope().getGlobalScope().getIntermediatesDir(), "classes/" + variantData.getVariantConfiguration().getDirName());
        task.setSource(variantData.getJavaSources());
        task.encoding = this.getExtension().getCompileOptions().getEncoding();
        task.setSourceCompatibility(this.getExtension().getCompileOptions().getSourceCompatibility().toString());
        ConventionMappingHelper.map((Task)task, "classpath", new Callable<ConfigurableFileCollection>(){

            @Override
            public ConfigurableFileCollection call() throws Exception {
                return project.files(new Object[]{LibraryTaskManager.this.androidBuilder.getCompileClasspath((VariantConfiguration)config)});
            }
        });
        task.dependsOn(new Object[]{variantData.getScope().getJavacTask().getName()});
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                if (task instanceof ExtractAnnotations) {
                    ExtractAnnotations extractAnnotations = (ExtractAnnotations)task;
                    extractAnnotations.bootClasspath = LibraryTaskManager.this.androidBuilder.getBootClasspathAsStrings();
                }
            }
        });
        return task;
    }

    private Task getAssembleDefault() {
        if (this.assembleDefault == null) {
            this.assembleDefault = (Task)this.project.getTasks().findByName("assembleDefault");
        }
        return this.assembleDefault;
    }
}

