/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

public class MergedNdkConfig
implements CoreNdkOptions {
    private String moduleName;
    private String cFlags;
    private List<String> ldLibs;
    private Set<String> abiFilters;
    private String stl;
    private Integer jobs;

    public void reset() {
        this.moduleName = null;
        this.cFlags = null;
        this.ldLibs = null;
        this.abiFilters = null;
    }

    @Override
    @Nullable
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    @Nullable
    public String getcFlags() {
        return this.cFlags;
    }

    @Override
    @Nullable
    public List<String> getLdLibs() {
        return this.ldLibs;
    }

    @Override
    @Nullable
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    @Override
    @Nullable
    public String getStl() {
        return this.stl;
    }

    @Override
    @Nullable
    public Integer getJobs() {
        return this.jobs;
    }

    public void append(@NonNull CoreNdkOptions ndkConfig) {
        if (ndkConfig.getModuleName() != null) {
            this.moduleName = ndkConfig.getModuleName();
        }
        if (ndkConfig.getStl() != null) {
            this.stl = ndkConfig.getStl();
        }
        if (ndkConfig.getJobs() != null) {
            this.jobs = ndkConfig.getJobs();
        }
        if (ndkConfig.getAbiFilters() != null) {
            if (this.abiFilters == null) {
                this.abiFilters = Sets.newHashSetWithExpectedSize((int)ndkConfig.getAbiFilters().size());
            }
            this.abiFilters.addAll(ndkConfig.getAbiFilters());
        }
        if (this.cFlags == null) {
            this.cFlags = ndkConfig.getcFlags();
        } else if (ndkConfig.getcFlags() != null && !ndkConfig.getcFlags().isEmpty()) {
            this.cFlags = this.cFlags + " " + ndkConfig.getcFlags();
        }
        if (ndkConfig.getLdLibs() != null) {
            if (this.ldLibs == null) {
                this.ldLibs = Lists.newArrayListWithCapacity((int)ndkConfig.getLdLibs().size());
            }
            this.ldLibs.addAll(ndkConfig.getLdLibs());
        }
    }
}

