/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;

public enum Toolchain {
    GCC("gcc"),
    CLANG("clang");

    @NonNull
    private final String name;

    @NonNull
    public static Toolchain getDefault() {
        return GCC;
    }

    @Nullable
    public static Toolchain getByName(@NonNull String toolchainName) {
        for (Toolchain toolchain : Toolchain.values()) {
            if (!toolchain.name.equals(toolchainName)) continue;
            return toolchain;
        }
        return null;
    }

    private Toolchain(String name) {
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }
}

