/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.builder.model.SyncIssue;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.logging.Logging;

public class DependencyChecker {
    @NonNull
    private static final ILogger logger = new LoggerWrapper(Logging.getLogger(DependencyChecker.class));
    @NonNull
    private final VariantDependencies configurationDependencies;
    private final boolean skipLibrariesInThePlatform;
    @NonNull
    private final Map<ModuleVersionIdentifier, Integer> legacyApiLevels = Maps.newHashMap();
    private final List<SyncIssue> syncIssues = Lists.newArrayList();

    public DependencyChecker(@NonNull VariantDependencies configurationDependencies, boolean skipLibrariesInThePlatform) {
        this.configurationDependencies = configurationDependencies;
        this.skipLibrariesInThePlatform = skipLibrariesInThePlatform;
    }

    @NonNull
    public Map<ModuleVersionIdentifier, Integer> getLegacyApiLevels() {
        return this.legacyApiLevels;
    }

    @NonNull
    public VariantDependencies getConfigurationDependencies() {
        return this.configurationDependencies;
    }

    public void addSyncIssue(SyncIssue syncIssue) {
        if (syncIssue != null) {
            this.syncIssues.add(syncIssue);
        }
    }

    @NonNull
    public List<SyncIssue> getSyncIssues() {
        return this.syncIssues;
    }

    public boolean excluded(ModuleVersionIdentifier id) {
        String group = id.getGroup();
        String name = id.getName();
        String version = id.getVersion();
        if ("com.google.android".equals(group) && "android".equals(name)) {
            int moduleLevel = DependencyChecker.getApiLevelFromMavenArtifact(version);
            this.legacyApiLevels.put(id, moduleLevel);
            logger.info("Ignoring Android API artifact %s for %s", new Object[]{id, this.configurationDependencies.getName()});
            return true;
        }
        if (!this.skipLibrariesInThePlatform) {
            return false;
        }
        if ("org.apache.httpcomponents".equals(group) && "httpclient".equals(name) || "xpp3".equals(group) && name.equals("xpp3") || "commons-logging".equals(group) && "commons-logging".equals(name) || "xerces".equals(group) && "xmlParserAPIs".equals(name)) {
            logger.warning("WARNING: Dependency %s is ignored for %s as it may be conflicting with the internal version provided by Android.\n         In case of problem, please repackage it with jarjar to change the class packages", new Object[]{id, this.configurationDependencies.getName()});
            return true;
        }
        if ("org.json".equals(group) && "json".equals(name)) {
            logger.warning("WARNING: Dependency %s is ignored for %s as it may be conflicting with the internal version provided by Android.\n         In case of problem, please repackage with jarjar to change the class packages", new Object[]{id, this.configurationDependencies.getName()});
            return true;
        }
        if ("org.khronos".equals(group) && "opengl-api".equals(name)) {
            logger.warning("WARNING: Dependency %s is ignored for %s as it may be conflicting with the internal version provided by Android.\n         In case of problem, please repackage with jarjar to change the class packages", new Object[]{id, this.configurationDependencies.getName()});
            return true;
        }
        return false;
    }

    private static int getApiLevelFromMavenArtifact(@NonNull String version) {
        if ("1.5_r3".equals(version) || "1.5_r4".equals(version)) {
            return 3;
        }
        if ("1.6_r2".equals(version)) {
            return 4;
        }
        if ("2.1_r1".equals(version) || version.equals("2.1.2")) {
            return 7;
        }
        if ("2.2.1".equals(version)) {
            return 8;
        }
        if ("2.3.1".equals(version)) {
            return 9;
        }
        if ("2.3.3".equals(version)) {
            return 10;
        }
        if ("4.0.1.2".equals(version)) {
            return 14;
        }
        if ("4.1.1.4".equals(version)) {
            return 15;
        }
        return -1;
    }
}

