/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.dsl.SplitOptions;
import com.android.resources.Density;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DensitySplitOptions
extends SplitOptions {
    private boolean strict = true;
    private boolean auto = false;
    private Set<String> compatibleScreens;

    @Override
    protected Set<String> getDefaultValues() {
        Density[] values = Density.values();
        HashSet fullList = Sets.newHashSetWithExpectedSize((int)(values.length - 2));
        for (Density value : values) {
            if (value == Density.NODPI || value == Density.ANYDPI || !value.isRecommended()) continue;
            fullList.add(value.getResourceValue());
        }
        return fullList;
    }

    @Override
    protected ImmutableSet<String> getAllowedValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Density value : Density.values()) {
            if (value == Density.NODPI || value == Density.ANYDPI) continue;
            builder.add((Object)value.getResourceValue());
        }
        return builder.build();
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setCompatibleScreens(@NonNull List<String> sizes) {
        this.compatibleScreens = Sets.newHashSet(sizes);
    }

    public void compatibleScreens(String ... sizes) {
        if (this.compatibleScreens == null) {
            this.compatibleScreens = Sets.newHashSet((Object[])sizes);
            return;
        }
        this.compatibleScreens.addAll(Arrays.asList(sizes));
    }

    @NonNull
    public Set<String> getCompatibleScreens() {
        if (this.compatibleScreens == null) {
            return Collections.emptySet();
        }
        return this.compatibleScreens;
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    public boolean isAuto() {
        return this.auto;
    }
}

