/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.resources.Density;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class PreprocessingOptions {
    private EnumSet<Density> densities = EnumSet.of(Density.MEDIUM, Density.HIGH, Density.XHIGH, Density.XXHIGH);
    private boolean preprocessResources = false;

    public boolean getPreprocessResources() {
        return this.preprocessResources;
    }

    public void setPreprocessResources(boolean preprocessResources) {
        this.preprocessResources = preprocessResources;
    }

    public Set<String> getDensities() {
        HashSet result = Sets.newHashSet();
        for (Density density : this.densities) {
            result.add(density.getResourceValue());
        }
        return result;
    }

    public void setDensities(Set<String> densities) {
        EnumSet<Density> newValue = EnumSet.noneOf(Density.class);
        for (String density : densities) {
            Density typedValue = Density.getEnum((String)density);
            Preconditions.checkArgument((typedValue != null ? 1 : 0) != 0, (String)"Unrecognized density %s", (Object[])new Object[]{density});
            newValue.add(typedValue);
        }
        this.densities = newValue;
    }

    public Set<Density> getTypedDensities() {
        return this.densities;
    }
}

