/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.model.LibraryImpl;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AndroidLibraryImpl
extends LibraryImpl
implements AndroidLibrary,
Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String project;
    @Nullable
    private final String variant;
    @NonNull
    private final File bundle;
    @NonNull
    private final File folder;
    @NonNull
    private final File manifest;
    @NonNull
    private final File jarFile;
    @NonNull
    private final Collection<File> localJars;
    @NonNull
    private final File resFolder;
    @NonNull
    private final File assetsFolder;
    @NonNull
    private final File jniFolder;
    @NonNull
    private final File aidlFolder;
    @NonNull
    private final File renderscriptFolder;
    @NonNull
    private final File proguardRules;
    @NonNull
    private final File lintJar;
    @NonNull
    private final File annotations;
    @NonNull
    private final File publicResources;
    @NonNull
    private final List<AndroidLibrary> dependencies;
    private final boolean isOptional;

    AndroidLibraryImpl(@NonNull LibraryDependency libraryDependency, @NonNull List<AndroidLibrary> dependencies, @NonNull Collection<File> localJarOverride, @Nullable String project, @Nullable String variant, @Nullable MavenCoordinates requestedCoordinates, @Nullable MavenCoordinates resolvedCoordinates) {
        super(requestedCoordinates, resolvedCoordinates);
        this.dependencies = dependencies;
        this.bundle = libraryDependency.getBundle();
        this.folder = libraryDependency.getFolder();
        this.manifest = libraryDependency.getManifest();
        this.jarFile = libraryDependency.getJarFile();
        this.localJars = Lists.newArrayList(localJarOverride);
        this.resFolder = libraryDependency.getResFolder();
        this.assetsFolder = libraryDependency.getAssetsFolder();
        this.jniFolder = libraryDependency.getJniFolder();
        this.aidlFolder = libraryDependency.getAidlFolder();
        this.renderscriptFolder = libraryDependency.getRenderscriptFolder();
        this.proguardRules = libraryDependency.getProguardRules();
        this.lintJar = libraryDependency.getLintJar();
        this.annotations = libraryDependency.getExternalAnnotations();
        this.publicResources = libraryDependency.getPublicResources();
        this.isOptional = libraryDependency.isOptional();
        this.project = project;
        this.variant = variant;
    }

    @Nullable
    public String getProject() {
        return this.project;
    }

    @Nullable
    public String getProjectVariant() {
        return this.variant;
    }

    @NonNull
    public File getBundle() {
        return this.bundle;
    }

    @NonNull
    public File getFolder() {
        return this.folder;
    }

    @NonNull
    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.dependencies;
    }

    @NonNull
    public File getManifest() {
        return this.manifest;
    }

    @NonNull
    public File getJarFile() {
        return this.jarFile;
    }

    @NonNull
    public Collection<File> getLocalJars() {
        return this.localJars;
    }

    @NonNull
    public File getResFolder() {
        return this.resFolder;
    }

    @NonNull
    public File getAssetsFolder() {
        return this.assetsFolder;
    }

    @NonNull
    public File getJniFolder() {
        return this.jniFolder;
    }

    @NonNull
    public File getAidlFolder() {
        return this.aidlFolder;
    }

    @NonNull
    public File getRenderscriptFolder() {
        return this.renderscriptFolder;
    }

    @NonNull
    public File getProguardRules() {
        return this.proguardRules;
    }

    @NonNull
    public File getLintJar() {
        return this.lintJar;
    }

    @NonNull
    public File getExternalAnnotations() {
        return this.annotations;
    }

    @NonNull
    public File getPublicResources() {
        return this.publicResources;
    }

    public boolean isOptional() {
        return this.isOptional;
    }
}

