/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.internal.ClosureBackedAction;

public class AndroidTaskRegistry {
    private final Map<String, AndroidTask> tasks = new HashMap<String, AndroidTask>();

    public synchronized <T extends Task> AndroidTask<T> create(TaskFactory taskFactory, String taskName, Class<T> taskClass, Action<T> configAction) {
        taskFactory.create(taskName, taskClass, configAction);
        AndroidTask<T> newTask = new AndroidTask<T>(taskName, taskClass);
        this.tasks.put(taskName, newTask);
        return newTask;
    }

    public synchronized AndroidTask<Task> create(TaskFactory taskFactory, String taskName, Closure configAction) {
        taskFactory.create(taskName, DefaultTask.class, new ClosureBackedAction(configAction));
        AndroidTask<Task> newTask = new AndroidTask<Task>(taskName, Task.class);
        this.tasks.put(taskName, newTask);
        return newTask;
    }

    public synchronized <T extends Task> AndroidTask<T> create(TaskFactory taskFactory, String taskName, Class<T> taskClass, Closure configAction) {
        taskFactory.create(taskName, taskClass, new ClosureBackedAction(configAction));
        AndroidTask<T> newTask = new AndroidTask<T>(taskName, taskClass);
        this.tasks.put(taskName, newTask);
        return newTask;
    }

    public <T extends Task> AndroidTask<T> create(TaskFactory taskFactory, TaskConfigAction<T> configAction) {
        return this.create(taskFactory, configAction.getName(), configAction.getType(), configAction);
    }
}

