/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.utils.StringHelper;
import java.io.File;

public class VariantOutputScope {
    @NonNull
    private VariantScope variantScope;
    @NonNull
    private BaseVariantOutputData variantOutputData;
    private AndroidTask<CompatibleScreensManifest> compatibleScreensManifestTask;
    private AndroidTask<? extends ManifestProcessorTask> manifestProcessorTask;
    private AndroidTask<ProcessAndroidResources> processResourcesTask;

    public VariantOutputScope(@NonNull VariantScope variantScope, @NonNull BaseVariantOutputData variantOutputData) {
        this.variantScope = variantScope;
        this.variantOutputData = variantOutputData;
    }

    @NonNull
    public GlobalScope getGlobalScope() {
        return this.variantScope.getGlobalScope();
    }

    @NonNull
    public VariantScope getVariantScope() {
        return this.variantScope;
    }

    @NonNull
    public BaseVariantOutputData getVariantOutputData() {
        return this.variantOutputData;
    }

    @NonNull
    public String getTaskName(@NonNull String prefix) {
        return this.getTaskName(prefix, "");
    }

    @NonNull
    public String getTaskName(@NonNull String prefix, @NonNull String suffix) {
        return prefix + StringHelper.capitalize((String)this.getVariantOutputData().getFullName()) + suffix;
    }

    @NonNull
    public File getPackageApk() {
        String apkName;
        ApkVariantData apkVariantData = (ApkVariantData)this.variantScope.getVariantData();
        boolean signedApk = apkVariantData.isSigned();
        String string = apkName = signedApk ? this.getGlobalScope().getProjectBaseName() + "-" + this.variantOutputData.getBaseName() + "-unaligned.apk" : this.getGlobalScope().getProjectBaseName() + "-" + this.variantOutputData.getBaseName() + "-unsigned.apk";
        if (!signedApk || !apkVariantData.getZipAlignEnabled()) {
            return this.getGlobalScope().getProject().file((Object)(this.getGlobalScope().getApkLocation() + "/" + apkName));
        }
        return this.getGlobalScope().getProject().file((Object)(this.getGlobalScope().getDefaultApkLocation() + "/" + apkName));
    }

    @NonNull
    public File getCompressedResourceFile() {
        return new File(this.getGlobalScope().getIntermediatesDir(), "/res/resources-" + this.variantOutputData.getBaseName() + "-stripped.ap_");
    }

    @NonNull
    public File getCompatibleScreensManifestFile() {
        return new File(this.getGlobalScope().getIntermediatesDir(), "/manifests/density/" + this.variantOutputData.getDirName() + "/AndroidManifest.xml");
    }

    @NonNull
    public File getManifestOutputFile() {
        switch (this.variantScope.getVariantConfiguration().getType()) {
            case DEFAULT: {
                return new File(this.getGlobalScope().getIntermediatesDir(), "/manifests/full/" + this.variantOutputData.getDirName() + "/AndroidManifest.xml");
            }
            case LIBRARY: {
                return new File(this.getGlobalScope().getIntermediatesDir(), "bundles/" + this.getVariantScope().getVariantConfiguration().getDirName() + "/AndroidManifest.xml");
            }
            case ANDROID_TEST: {
                return new File(this.getGlobalScope().getIntermediatesDir(), "manifest/" + this.variantScope.getVariantConfiguration().getDirName() + "/AndroidManifest.xml");
            }
        }
        throw new RuntimeException("getManifestOutputFile called for an unexpected variant.");
    }

    @NonNull
    public File getProcessResourcePackageOutputFile() {
        return new File(this.getGlobalScope().getIntermediatesDir(), "res/resources-" + this.variantOutputData.getBaseName() + ".ap_");
    }

    @Nullable
    public AndroidTask<CompatibleScreensManifest> getCompatibleScreensManifestTask() {
        return this.compatibleScreensManifestTask;
    }

    public void setCompatibleScreensManifestTask(@Nullable AndroidTask<CompatibleScreensManifest> compatibleScreensManifestTask) {
        this.compatibleScreensManifestTask = compatibleScreensManifestTask;
    }

    public AndroidTask<? extends ManifestProcessorTask> getManifestProcessorTask() {
        return this.manifestProcessorTask;
    }

    public void setManifestProcessorTask(AndroidTask<? extends ManifestProcessorTask> manifestProcessorTask) {
        this.manifestProcessorTask = manifestProcessorTask;
    }

    public AndroidTask<ProcessAndroidResources> getProcessResourcesTask() {
        return this.processResourcesTask;
    }

    public void setProcessResourcesTask(AndroidTask<ProcessAndroidResources> processResourcesTask) {
        this.processResourcesTask = processResourcesTask;
    }
}

