/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.AndroidAsciiReportRenderer;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.logging.StyledTextOutputFactory;

public class DependencyReportTask
extends DefaultAndroidTask {
    private AndroidAsciiReportRenderer renderer = new AndroidAsciiReportRenderer();
    private Set<BaseVariantData> variants = new HashSet<BaseVariantData>();

    @TaskAction
    public void generate() throws IOException {
        this.renderer.setOutput(((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create(((Object)((Object)this)).getClass()));
        TreeSet<BaseVariantData> sortedConfigurations = new TreeSet<BaseVariantData>(new Comparator<BaseVariantData>(){

            @Override
            public int compare(BaseVariantData conf1, BaseVariantData conf2) {
                return conf1.getName().compareTo(conf2.getName());
            }
        });
        sortedConfigurations.addAll(this.getVariants());
        for (BaseVariantData variant : sortedConfigurations) {
            this.renderer.startVariant(variant);
            this.renderer.render(variant);
        }
    }

    public Set<BaseVariantData> getVariants() {
        return this.variants;
    }

    public void setVariants(@NonNull Collection<? extends BaseVariantData> variants) {
        this.variants.addAll(variants);
    }

    public void setVariants(Set<BaseVariantData> variants) {
        this.variants = variants;
    }

    public AndroidAsciiReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(@NonNull AndroidAsciiReportRenderer renderer) {
        this.renderer = renderer;
    }
}

