/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.builder.testing.MockableJarGenerator;
import java.io.File;
import java.io.IOException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class MockableAndroidJarTask
extends DefaultAndroidTask {
    private File mAndroidJar;
    private File mOutputFile;
    private boolean mReturnDefaultValues;

    @TaskAction
    public void createMockableJar() throws IOException {
        MockableJarGenerator generator = new MockableJarGenerator(this.getReturnDefaultValues());
        this.getOutputFile().delete();
        this.getLogger().info(String.format("Creating %s from $s.", this.getOutputFile().getAbsolutePath(), this.getAndroidJar().getAbsolutePath()));
        generator.createMockableJar(this.getAndroidJar(), this.getOutputFile());
    }

    @Input
    public boolean getReturnDefaultValues() {
        return this.mReturnDefaultValues;
    }

    @OutputFile
    public File getOutputFile() {
        return this.mOutputFile;
    }

    public void setOutputFile(File outputFile) {
        this.mOutputFile = outputFile;
    }

    @InputFile
    public File getAndroidJar() {
        return this.mAndroidJar;
    }

    public void setAndroidJar(File androidJar) {
        this.mAndroidJar = androidJar;
    }
}

