/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.builder.core.VariantType;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.CollectionUtils;

public class SourceSetsTask
extends AbstractReportTask {
    private final TextReportRenderer mRenderer = new TextReportRenderer();
    private AndroidConfig config;

    protected ReportRenderer getRenderer() {
        return this.mRenderer;
    }

    @Input
    public AndroidConfig getConfig() {
        return this.config;
    }

    public void setConfig(AndroidConfig config) {
        this.config = config;
    }

    protected void generate(Project project) throws IOException {
        if (this.config != null) {
            for (AndroidSourceSet sourceSet : this.config.getSourceSets()) {
                this.mRenderer.getBuilder().subheading(sourceSet.getName());
                this.renderKeyValue("Compile configuration: ", sourceSet.getCompileConfigurationName());
                this.renderKeyValue("build.gradle name: ", "android.sourceSets." + sourceSet.getName());
                this.renderDirectorySet("Java sources", sourceSet.getJava(), project);
                if (!sourceSet.getName().startsWith(VariantType.UNIT_TEST.getPrefix())) {
                    this.renderKeyValue("Manifest file: ", project.getRootProject().relativePath((Object)sourceSet.getManifest().getSrcFile()));
                    this.renderDirectorySet("Android resources", sourceSet.getRes(), project);
                    this.renderDirectorySet("Assets", sourceSet.getAssets(), project);
                    this.renderDirectorySet("AIDL sources", sourceSet.getAidl(), project);
                    this.renderDirectorySet("RenderScript sources", sourceSet.getRenderscript(), project);
                    this.renderDirectorySet("JNI sources", sourceSet.getJni(), project);
                    this.renderDirectorySet("JNI libraries", sourceSet.getJniLibs(), project);
                }
                this.renderDirectorySet("Java-style resources", sourceSet.getResources(), project);
                this.mRenderer.getTextOutput().println();
            }
        }
        this.mRenderer.complete();
    }

    private void renderDirectorySet(String name, AndroidSourceDirectorySet java, Project project) {
        ArrayList relativePaths = Lists.newArrayList();
        for (File file : java.getSrcDirs()) {
            relativePaths.add(project.getRootProject().relativePath((Object)file));
        }
        this.renderKeyValue(name + ": ", String.format("[%s]", CollectionUtils.join((String)", ", (Iterable)relativePaths)));
    }

    private void renderKeyValue(String o, String o1) {
        this.mRenderer.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)o);
        this.mRenderer.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)o1);
        this.mRenderer.getTextOutput().println();
    }
}

