/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.annotations.NonNull;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.ApiVersion;
import com.android.builder.testing.TestData;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractTestDataImpl
implements TestData {
    @NonNull
    private final VariantConfiguration<?, ?, ?> testVariantConfig;
    @NonNull
    private Map<String, String> extraInstrumentationTestRunnerArgs;

    public AbstractTestDataImpl(@NonNull VariantConfiguration<?, ?, ?> testVariantConfig) {
        this.testVariantConfig = (VariantConfiguration)Preconditions.checkNotNull(testVariantConfig);
        this.extraInstrumentationTestRunnerArgs = Maps.newHashMap();
    }

    @NonNull
    public String getInstrumentationRunner() {
        return this.testVariantConfig.getInstrumentationRunner();
    }

    @NonNull
    public Map<String, String> getInstrumentationRunnerArguments() {
        return ImmutableMap.builder().putAll(this.testVariantConfig.getInstrumentationRunnerArguments()).putAll(this.extraInstrumentationTestRunnerArgs).build();
    }

    public void setExtraInstrumentationTestRunnerArgs(@NonNull Map<String, String> extraInstrumentationTestRunnerArgs) {
        this.extraInstrumentationTestRunnerArgs = ImmutableMap.copyOf(extraInstrumentationTestRunnerArgs);
    }

    public boolean isTestCoverageEnabled() {
        return this.testVariantConfig.isTestCoverageEnabled();
    }

    @NonNull
    public ApiVersion getMinSdkVersion() {
        return this.testVariantConfig.getMinSdkVersion();
    }

    @NonNull
    public String getFlavorName() {
        return this.testVariantConfig.getFlavorName().toUpperCase(Locale.getDefault());
    }
}

