/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.model.SourceProvider;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;

public class TestDataImpl
extends AbstractTestDataImpl {
    @NonNull
    private final TestVariantData testVariantData;
    @NonNull
    private final VariantConfiguration testVariantConfig;

    public TestDataImpl(@NonNull TestVariantData testVariantData) {
        super(testVariantData.getVariantConfiguration());
        this.testVariantData = testVariantData;
        this.testVariantConfig = testVariantData.getVariantConfiguration();
        if (testVariantData.getOutputs().size() > 1) {
            throw new RuntimeException("Multi-output in test variant not yet supported");
        }
    }

    @NonNull
    public String getApplicationId() {
        return this.testVariantData.getApplicationId();
    }

    @Nullable
    public String getTestedApplicationId() {
        return this.testVariantConfig.getTestedApplicationId();
    }

    public boolean isLibrary() {
        TestedVariantData testedVariantData = this.testVariantData.getTestedVariantData();
        BaseVariantData testedVariantData2 = (BaseVariantData)((Object)testedVariantData);
        return testedVariantData2.getVariantConfiguration().getType() == VariantType.LIBRARY;
    }

    @NonNull
    public ImmutableList<File> getTestedApks(@NonNull ProcessExecutor processExecutor, @Nullable File splitSelectExe, @NonNull DeviceConfigProvider deviceConfigProvider, @NonNull ILogger logger) throws ProcessException {
        BaseVariantData testedVariantData = (BaseVariantData)((Object)this.testVariantData.getTestedVariantData());
        ImmutableList.Builder apks = ImmutableList.builder();
        apks.addAll((Iterable)SplitOutputMatcher.computeBestOutput((ProcessExecutor)processExecutor, (File)splitSelectExe, (DeviceConfigProvider)deviceConfigProvider, testedVariantData.getOutputs(), testedVariantData.getVariantConfiguration().getSupportedAbis()));
        return apks.build();
    }

    @NonNull
    public File getTestApk() {
        return ((ApkVariantOutputData)this.testVariantData.getOutputs().get(0)).getOutputFile();
    }

    @NonNull
    public List<File> getTestDirectories() {
        GradleVariantConfiguration variantConfiguration = this.testVariantData.getVariantConfiguration();
        ImmutableList.Builder javaDirectories = ImmutableList.builder();
        for (SourceProvider sourceProvider : variantConfiguration.getSortedSourceProviders()) {
            javaDirectories.addAll((Iterable)sourceProvider.getJavaDirectories());
        }
        return javaDirectories.build();
    }
}

