/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.PostCompilationData;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.tasks.SimpleWorkQueue;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.Task;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import proguard.ParseException;
import proguard.gradle.ProGuardTask;

public class AndroidProGuardTask
extends ProGuardTask
implements FileSupplier {
    @InputFile
    @Optional
    @Nullable
    File mappingFile;
    @InputFile
    @Optional
    @Nullable
    File testedAppMappingFile;

    public void printmapping(Object printMapping) throws ParseException {
        this.mappingFile = (File)printMapping;
        super.printmapping(printMapping);
    }

    public void applymapping(Object applyMapping) throws ParseException {
        this.testedAppMappingFile = (File)applyMapping;
    }

    public File get() {
        return this.mappingFile;
    }

    @Override
    @NonNull
    public org.gradle.api.Task getTask() {
        return this;
    }

    @TaskAction
    public void proguard() throws IOException, ParseException {
        Job job = new Job(this.getName(), (Task)new Task<Void>(){

            public void run(@NonNull Job<Void> job, @NonNull JobContext<Void> context) throws IOException {
                try {
                    AndroidProGuardTask.this.doMinification();
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
            }
        });
        try {
            SimpleWorkQueue.push((Job<Void>)job);
            job.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void doMinification() throws ParseException, IOException {
        if (this.testedAppMappingFile != null && this.testedAppMappingFile.exists()) {
            super.applymapping((Object)this.testedAppMappingFile);
        }
        super.proguard();
    }

    public static class ConfigAction
    implements TaskConfigAction<AndroidProGuardTask> {
        private VariantScope scope;
        private Callable<File> inputDir;
        private Callable<File> javaResourcesInputDir;
        private Callable<List<File>> inputLibraries;

        public ConfigAction(VariantScope scope, PostCompilationData pcData) {
            this.scope = scope;
            this.inputDir = pcData.getInputDirCallable();
            this.javaResourcesInputDir = pcData.getJavaResourcesInputDirCallable();
            this.inputLibraries = pcData.getInputLibrariesCallable();
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("proguard");
        }

        @Override
        public Class<AndroidProGuardTask> getType() {
            return AndroidProGuardTask.class;
        }

        public void execute(AndroidProGuardTask proguardTask) {
            File outFile;
            final BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            final GradleVariantConfiguration variantConfig = this.scope.getVariantData().getVariantConfiguration();
            final BaseVariantData testedVariantData = this.scope.getTestedVariantData();
            final BaseVariantOutputData variantOutputData = this.scope.getVariantData().getOutputs().get(0);
            if (testedVariantData != null) {
                proguardTask.dependsOn(new Object[]{testedVariantData.getScope().getObfuscationTask().getName()});
            }
            variantData.obfuscationTask = proguardTask;
            variantData.mappingFileProviderTask = proguardTask;
            variantData.obfuscatedClassesJar = outFile = variantData instanceof LibraryVariantData ? new File(String.valueOf(this.scope.getGlobalScope().getBuildDir()) + "/" + "intermediates" + "/" + "bundles" + "/" + variantData.getVariantConfiguration().getDirName() + "/classes.jar") : new File(String.valueOf(this.scope.getGlobalScope().getBuildDir()) + "/" + "intermediates" + "/classes-proguard/" + variantData.getVariantConfiguration().getDirName() + "/classes.jar");
            try {
                if (testedVariantData != null) {
                    proguardTask.dontshrink();
                    proguardTask.dontoptimize();
                    proguardTask.keep("class * {*;}");
                    proguardTask.keep("interface * {*;}");
                    proguardTask.keep("enum * {*;}");
                    proguardTask.keepattributes();
                    proguardTask.applymapping(testedVariantData.getMappingFile());
                    proguardTask.configuration(testedVariantData.getVariantConfiguration().getTestProguardFiles());
                } else {
                    if (variantConfig.isTestCoverageEnabled()) {
                        proguardTask.keep("class com.vladium.** {*;}");
                        proguardTask.keep("class org.jacoco.** {*;}");
                        proguardTask.keep("interface org.jacoco.** {*;}");
                        proguardTask.dontwarn("org.jacoco.**");
                    }
                    proguardTask.configuration(new Callable<Collection<File>>(){

                        @Override
                        public Collection<File> call() throws Exception {
                            List proguardFiles = variantConfig.getProguardFiles(true, Collections.singletonList(ConfigAction.this.getDefaultProguardFile("proguard-android.txt")));
                            proguardFiles.add(variantOutputData.processResourcesTask.getProguardOutputFile());
                            return proguardFiles;
                        }
                    });
                }
                if (variantData instanceof LibraryVariantData) {
                    String packageName = variantConfig.getPackageFromManifest();
                    if (packageName == null) {
                        throw new BuildException("Failed to read manifest", null);
                    }
                    packageName = packageName.replace(".", "/");
                    String exclude = "!" + packageName + "/R.class";
                    exclude = exclude + ", !" + packageName + "/R$*.class";
                    if (!this.scope.getGlobalScope().getExtension().getPackageBuildConfig().booleanValue()) {
                        exclude = exclude + ", !" + packageName + "/Manifest.class";
                        exclude = exclude + ", !" + packageName + "/Manifest$*.class";
                        exclude = exclude + ", !" + packageName + "/BuildConfig.class";
                    }
                    proguardTask.injars((Map)ImmutableMap.of((Object)"filter", (Object)exclude), this.inputDir);
                    String include = exclude.replace("!", "");
                    LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>(1);
                    map1.put("filter", include);
                    proguardTask.libraryjars(map1, this.inputDir);
                    Callable<List<File>> inJars = new Callable<List<File>>(){

                        @Override
                        public List<File> call() throws Exception {
                            return DependencyManager.getPackagedLocalJarFileList(variantData.getVariantDependency());
                        }
                    };
                    proguardTask.injars((Map)ImmutableMap.of((Object)"filter", (Object)"!META-INF/MANIFEST.MF"), inJars);
                    Callable<Iterable<File>> libJars = new Callable<Iterable<File>>(){

                        @Override
                        public Iterable<File> call() throws Exception {
                            Set compiledJars = ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getCompileClasspath(variantConfig);
                            final List<File> localJars = DependencyManager.getPackagedLocalJarFileList(variantData.getVariantDependency());
                            return Iterables.filter((Iterable)compiledJars, (Predicate)new Predicate<File>(){

                                public boolean apply(File file) {
                                    return !localJars.contains(file);
                                }
                            });
                        }
                    };
                    proguardTask.libraryjars((Map)ImmutableMap.of((Object)"filter", (Object)"!META-INF/MANIFEST.MF"), libJars);
                    proguardTask.keeppackagenames();
                } else {
                    proguardTask.injars(this.inputDir);
                    if (this.javaResourcesInputDir != null) {
                        proguardTask.injars(this.javaResourcesInputDir);
                    }
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
                    map.put("filter", "!META-INF/MANIFEST.MF");
                    proguardTask.injars(map, this.inputLibraries);
                    Callable<List<File>> libJars = new Callable<List<File>>(){

                        @Override
                        public List<File> call() throws Exception {
                            return variantData.getVariantConfiguration().getProvidedOnlyJars();
                        }
                    };
                    proguardTask.libraryjars(libJars);
                }
                proguardTask.doFirst((Action)new Action<org.gradle.api.Task>(){

                    public void execute(org.gradle.api.Task proguardTask) {
                        for (String runtimeJar : ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getBootClasspathAsStrings()) {
                            try {
                                ((AndroidProGuardTask)proguardTask).libraryjars(runtimeJar);
                            }
                            catch (ParseException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                });
                if (testedVariantData != null) {
                    proguardTask.libraryjars(testedVariantData.javacTask.getDestinationDir());
                    Callable<Set<File>> testedPackagedJars = new Callable<Set<File>>(){

                        @Override
                        public Set<File> call() throws Exception {
                            return ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getPackagedJars((VariantConfiguration)testedVariantData.getVariantConfiguration());
                        }
                    };
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
                    map.put("filter", "!META-INF/MANIFEST.MF");
                    proguardTask.libraryjars(map, testedPackagedJars);
                }
                proguardTask.outjars(outFile);
                final File proguardOut = new File(String.valueOf(this.scope.getGlobalScope().getBuildDir()) + "/" + "outputs" + "/mapping/" + variantData.getVariantConfiguration().getDirName());
                proguardTask.dump(new File(proguardOut, "dump.txt"));
                proguardTask.printseeds(new File(proguardOut, "seeds.txt"));
                proguardTask.printusage(new File(proguardOut, "usage.txt"));
                proguardTask.printmapping(new File(proguardOut, "mapping.txt"));
                proguardTask.doFirst((Closure)new Closure<Boolean>((Object)this, (Object)this){

                    public Boolean doCall(org.gradle.api.Task it) {
                        return proguardOut.mkdirs();
                    }

                    public Boolean doCall() {
                        return this.doCall(null);
                    }
                });
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private File getDefaultProguardFile(String name) {
            File sdkDir = this.scope.getGlobalScope().getSdkHandler().getAndCheckSdkFolder();
            return new File(sdkDir, "tools" + File.separatorChar + "proguard" + File.separatorChar + name);
        }
    }
}

