/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AbstractAndroidCompile;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.tasks.BinaryFileProviderTask;
import com.android.build.gradle.tasks.SimpleWorkQueue;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.Task;
import com.android.ide.common.process.ProcessException;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.FullRevision;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class JackTask
extends AbstractAndroidCompile
implements FileSupplier,
BinaryFileProviderTask {
    public static final FullRevision JACK_MIN_REV = new FullRevision(21, 1, 0);
    private AndroidBuilder androidBuilder;
    private boolean isVerbose;
    private boolean isDebugLog;
    private Collection<File> packagedLibraries;
    private Collection<File> proguardFiles;
    private Collection<File> jarJarRuleFiles;
    private boolean debug;
    private File tempFolder;
    private File jackFile;
    private File mappingFile;
    private boolean multiDexEnabled;
    private int minSdkVersion;
    private String javaMaxHeapSize;
    private File incrementalDir;
    private static final Function<File, String> GET_ABSOLUTE_PATH = new Function<File, String>(){

        public String apply(File file) {
            return file.getAbsolutePath();
        }
    };

    @TaskAction
    public void compile() {
        Job job = new Job(this.getName(), (Task)new Task<Void>(){

            public void run(@NonNull Job<Void> job, @NonNull JobContext<Void> context) throws IOException {
                try {
                    JackTask.this.doMinification();
                }
                catch (ProcessException e) {
                    throw new IOException(e);
                }
            }
        });
        try {
            SimpleWorkQueue.push((Job<Void>)job);
            job.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void doMinification() throws ProcessException, IOException {
        if (System.getenv("USE_JACK_API") != null || !this.androidBuilder.convertByteCodeUsingJackApis(this.getDestinationDir(), this.getJackFile(), (Collection)this.getClasspath().getFiles(), this.getPackagedLibraries(), (Collection)this.getSource().getFiles(), this.getProguardFiles(), this.getMappingFile(), this.getJarJarRuleFiles(), this.getIncrementalDir(), this.isMultiDexEnabled(), this.getMinSdkVersion())) {
            this.androidBuilder.convertByteCodeWithJack(this.getDestinationDir(), this.getJackFile(), this.computeBootClasspath(), this.getPackagedLibraries(), this.computeEcjOptionFile(), this.getProguardFiles(), this.getMappingFile(), this.getJarJarRuleFiles(), this.isMultiDexEnabled(), this.getMinSdkVersion(), this.isDebugLog, this.getJavaMaxHeapSize());
        }
    }

    private File computeEcjOptionFile() throws IOException {
        File folder = this.getTempFolder();
        folder.mkdirs();
        File file = new File(folder, "ecj-options.txt");
        StringBuilder sb = new StringBuilder();
        for (File sourceFile : this.getSource().getFiles()) {
            sb.append(sourceFile.getAbsolutePath()).append("\n");
        }
        file.getParentFile().mkdirs();
        Files.write((CharSequence)sb.toString(), (File)file, (Charset)Charsets.UTF_8);
        return file;
    }

    private String computeBootClasspath() {
        return Joiner.on((char)':').join(Iterables.transform((Iterable)this.getClasspath().getFiles(), GET_ABSOLUTE_PATH));
    }

    @InputFile
    public File getJackExe() {
        return new File(this.androidBuilder.getTargetInfo().getBuildTools().getPath(BuildToolInfo.PathId.JACK));
    }

    public AndroidBuilder getAndroidBuilder() {
        return this.androidBuilder;
    }

    public void setAndroidBuilder(AndroidBuilder androidBuilder) {
        this.androidBuilder = androidBuilder;
    }

    public boolean getIsVerbose() {
        return this.isVerbose;
    }

    public void setIsVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public boolean getIsDebugLog() {
        return this.isDebugLog;
    }

    public void setIsDebugLog(boolean isDebugLog) {
        this.isDebugLog = isDebugLog;
    }

    @InputFiles
    public Collection<File> getPackagedLibraries() {
        return this.packagedLibraries;
    }

    public void setPackagedLibraries(Collection<File> packagedLibraries) {
        this.packagedLibraries = packagedLibraries;
    }

    @InputFiles
    @Optional
    public Collection<File> getProguardFiles() {
        return this.proguardFiles;
    }

    public void setProguardFiles(Collection<File> proguardFiles) {
        this.proguardFiles = proguardFiles;
    }

    @InputFiles
    @Optional
    public Collection<File> getJarJarRuleFiles() {
        return this.jarJarRuleFiles;
    }

    public void setJarJarRuleFiles(Collection<File> jarJarRuleFiles) {
        this.jarJarRuleFiles = jarJarRuleFiles;
    }

    @Input
    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public File getTempFolder() {
        return this.tempFolder;
    }

    public void setTempFolder(File tempFolder) {
        this.tempFolder = tempFolder;
    }

    @OutputFile
    public File getJackFile() {
        return this.jackFile;
    }

    public void setJackFile(File jackFile) {
        this.jackFile = jackFile;
    }

    @OutputFile
    @Optional
    public File getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(File mappingFile) {
        this.mappingFile = mappingFile;
    }

    @Input
    public boolean isMultiDexEnabled() {
        return this.multiDexEnabled;
    }

    public void setMultiDexEnabled(boolean multiDexEnabled) {
        this.multiDexEnabled = multiDexEnabled;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public void setMinSdkVersion(int minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @Input
    @Optional
    public String getJavaMaxHeapSize() {
        return this.javaMaxHeapSize;
    }

    public void setJavaMaxHeapSize(String javaMaxHeapSize) {
        this.javaMaxHeapSize = javaMaxHeapSize;
    }

    @Input
    @Optional
    public File getIncrementalDir() {
        return this.incrementalDir;
    }

    public void setIncrementalDir(File incrementalDir) {
        this.incrementalDir = incrementalDir;
    }

    @Override
    @NonNull
    public BinaryFileProviderTask.Artifact getArtifact() {
        return new BinaryFileProviderTask.Artifact(BinaryFileProviderTask.BinaryArtifactType.JACK, this.getJackFile());
    }

    @Override
    @NonNull
    public org.gradle.api.Task getTask() {
        return this;
    }

    public File get() {
        return this.getMappingFile();
    }

    public static class ConfigAction
    implements TaskConfigAction<JackTask> {
        private final VariantScope scope;
        private final boolean isVerbose;
        private final boolean isDebugLog;

        public ConfigAction(VariantScope scope, boolean isVerbose, boolean isDebugLog) {
            this.scope = scope;
            this.isVerbose = isVerbose;
            this.isDebugLog = isDebugLog;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("compile", "JavaWithJack");
        }

        @Override
        public Class<JackTask> getType() {
            return JackTask.class;
        }

        public void execute(JackTask jackTask) {
            jackTask.setIsVerbose(this.isVerbose);
            jackTask.setIsDebugLog(this.isDebugLog);
            GlobalScope globalScope = this.scope.getGlobalScope();
            jackTask.androidBuilder = globalScope.getAndroidBuilder();
            jackTask.setJavaMaxHeapSize(globalScope.getExtension().getDexOptions().getJavaMaxHeapSize());
            jackTask.setSource(this.scope.getVariantData().getJavaSources());
            final GradleVariantConfiguration config = this.scope.getVariantData().getVariantConfiguration();
            jackTask.setMultiDexEnabled(config.isMultiDexEnabled());
            jackTask.setMinSdkVersion(config.getMinSdkVersion().getApiLevel());
            jackTask.incrementalDir = this.scope.getJackIncrementalDir();
            if (this.scope.getTestedVariantData() instanceof ApplicationVariantData) {
                ConventionMappingHelper.map((org.gradle.api.Task)jackTask, "classpath", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        Project project = ConfigAction.this.scope.getGlobalScope().getProject();
                        return project.fileTree((Object)ConfigAction.this.scope.getJillRuntimeLibrariesDir()).plus((FileTree)project.fileTree((Object)ConfigAction.this.scope.getTestedVariantData().getScope().getJillRuntimeLibrariesDir())).plus((FileTree)project.fileTree((Object)ConfigAction.this.scope.getTestedVariantData().getScope().getJackClassesZip()));
                    }
                });
            } else {
                ConventionMappingHelper.map((org.gradle.api.Task)jackTask, "classpath", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return ConfigAction.this.scope.getGlobalScope().getProject().fileTree((Object)ConfigAction.this.scope.getJillRuntimeLibrariesDir());
                    }
                });
            }
            ConventionMappingHelper.map((org.gradle.api.Task)jackTask, "packagedLibraries", new Callable<Collection<File>>(){

                @Override
                public Collection<File> call() throws Exception {
                    return ConfigAction.this.scope.getGlobalScope().getProject().fileTree((Object)ConfigAction.this.scope.getJillPackagedLibrariesDir()).getFiles();
                }
            });
            jackTask.setDestinationDir(this.scope.getJackDestinationDir());
            jackTask.setJackFile(this.scope.getJackClassesZip());
            jackTask.setTempFolder(new File(this.scope.getGlobalScope().getIntermediatesDir(), "/tmp/jack/" + this.scope.getVariantConfiguration().getDirName()));
            if (config.isMinifyEnabled()) {
                ConventionMappingHelper.map((org.gradle.api.Task)jackTask, "proguardFiles", new Callable<List<File>>(){

                    @Override
                    public List<File> call() throws Exception {
                        File sdkDir = ConfigAction.this.scope.getGlobalScope().getSdkHandler().getAndCheckSdkFolder();
                        File defaultProguardFile = new File(sdkDir, "tools" + File.separatorChar + "proguard" + File.separatorChar + "proguard-android.txt");
                        List proguardFiles = config.getProguardFiles(true, (List)ImmutableList.of((Object)defaultProguardFile));
                        File proguardResFile = ConfigAction.this.scope.getProcessAndroidResourcesProguardOutputFile();
                        proguardFiles.add(proguardResFile);
                        if (ConfigAction.this.scope.getTestedVariantData() != null) {
                            proguardResFile = ConfigAction.this.scope.getTestedVariantData().getScope().getProcessAndroidResourcesProguardOutputFile();
                            proguardFiles.add(proguardResFile);
                        }
                        return proguardFiles;
                    }
                });
                jackTask.mappingFile = new File(this.scope.getProguardOutputFolder(), "mapping.txt");
            }
            ConventionMappingHelper.map((org.gradle.api.Task)jackTask, "jarJarRuleFiles", new Callable<List<File>>(){

                @Override
                public List<File> call() throws Exception {
                    ArrayList jarJarRuleFiles = Lists.newArrayListWithCapacity((int)config.getJarJarRuleFiles().size());
                    Project project = ConfigAction.this.scope.getGlobalScope().getProject();
                    for (File file : config.getJarJarRuleFiles()) {
                        jarJarRuleFiles.add(project.file((Object)file));
                    }
                    return jarJarRuleFiles;
                }
            });
            AbstractCompilesUtil.configureLanguageLevel(jackTask, this.scope.getGlobalScope().getExtension().getCompileOptions(), this.scope.getGlobalScope().getExtension().getCompileSdkVersion());
            this.scope.getVariantData().jackTask = jackTask;
            this.scope.getVariantData().javaCompilerTask = jackTask;
            this.scope.getVariantData().mappingFileProviderTask = jackTask;
            this.scope.getVariantData().binayFileProviderTask = jackTask;
        }
    }
}

