/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ResourceException;
import com.android.builder.png.QueuedCruncher;
import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.FileValidity;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergedResourceWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourceSet;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.FullRevision;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class MergeResources
extends IncrementalTask {
    public static final FullRevision NORMALIZE_RESOURCES_BUILD_TOOLS = new FullRevision(21, 0, 0);
    private File outputDir;
    private File publicFile;
    private boolean process9Patch;
    private boolean crunchPng;
    private boolean useNewCruncher;
    private boolean insertSourceMarkers = true;
    private boolean normalizeResources;
    private List<ResourceSet> inputResourceSets;
    private final FileValidity<ResourceSet> fileValidity = new FileValidity();

    @InputFiles
    public Iterable<File> getRawInputFolders() {
        return MergeResources.flattenSourceSets(this.getInputResourceSets());
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    private PngCruncher getCruncher() {
        if (this.getUseNewCruncher()) {
            if (this.getBuilder().getTargetInfo().getBuildTools().getRevision().getMajor() >= 22) {
                return QueuedCruncher.Builder.INSTANCE.newCruncher(this.getBuilder().getTargetInfo().getBuildTools().getPath(BuildToolInfo.PathId.AAPT), this.getILogger());
            }
            this.getLogger().info("New PNG cruncher will be enabled with build tools 22 and above.");
        }
        return this.getBuilder().getAaptCruncher();
    }

    @Override
    protected void doFullTaskAction() {
        File destinationDir = this.getOutputDir();
        this.emptyFolder(destinationDir);
        List<ResourceSet> resourceSets = this.getInputResourceSets();
        ResourceMerger merger = new ResourceMerger();
        try {
            for (ResourceSet resourceSet : resourceSets) {
                resourceSet.setNormalizeResources(this.normalizeResources);
                resourceSet.loadFromFiles(this.getILogger());
                merger.addDataSet((DataSet)resourceSet);
            }
            MergedResourceWriter writer = new MergedResourceWriter(destinationDir, this.getCruncher(), this.getCrunchPng(), this.getProcess9Patch(), this.getPublicFile());
            writer.setInsertSourceMarkers(this.getInsertSourceMarkers());
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer);
        }
        catch (MergingException e) {
            System.out.println(e.getMessage());
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) {
        ResourceMerger merger = new ResourceMerger();
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            List<ResourceSet> resourceSets = this.getInputResourceSets();
            for (ResourceSet resourceSet : resourceSets) {
                resourceSet.setNormalizeResources(this.normalizeResources);
            }
            if (!merger.checkValidUpdate(resourceSets)) {
                this.getLogger().info("Changed Resource sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry entry : changedInputs.entrySet()) {
                File changedFile = (File)entry.getKey();
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((ResourceSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, (FileStatus)entry.getValue(), this.getILogger())) continue;
                this.getLogger().info(String.format("Failed to process %s event! Full task run", entry.getValue()));
                this.doFullTaskAction();
                return;
            }
            MergedResourceWriter writer = new MergedResourceWriter(this.getOutputDir(), this.getCruncher(), this.getCrunchPng(), this.getProcess9Patch(), this.getPublicFile());
            writer.setInsertSourceMarkers(this.getInsertSourceMarkers());
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer);
        }
        catch (MergingException e) {
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.fileValidity.clear();
        }
    }

    @Input
    public boolean isProcess9Patch() {
        return this.process9Patch;
    }

    @Input
    public boolean isCrunchPng() {
        return this.crunchPng;
    }

    @Input
    public boolean isUseNewCruncher() {
        return this.useNewCruncher;
    }

    @Input
    public boolean isInsertSourceMarkers() {
        return this.insertSourceMarkers;
    }

    @Input
    public boolean isNormalizeResources() {
        return this.normalizeResources;
    }

    public void setNormalizeResources(boolean normalizeResources) {
        this.normalizeResources = normalizeResources;
    }

    public List<ResourceSet> getInputResourceSets() {
        return this.inputResourceSets;
    }

    public void setInputResourceSets(List<ResourceSet> inputResourceSets) {
        this.inputResourceSets = inputResourceSets;
    }

    public boolean getUseNewCruncher() {
        return this.useNewCruncher;
    }

    public void setUseNewCruncher(boolean useNewCruncher) {
        this.useNewCruncher = useNewCruncher;
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public boolean getCrunchPng() {
        return this.crunchPng;
    }

    public void setCrunchPng(boolean crunchPng) {
        this.crunchPng = crunchPng;
    }

    public boolean getProcess9Patch() {
        return this.process9Patch;
    }

    public void setProcess9Patch(boolean process9Patch) {
        this.process9Patch = process9Patch;
    }

    @Optional
    @OutputFile
    public File getPublicFile() {
        return this.publicFile;
    }

    public void setPublicFile(File publicFile) {
        this.publicFile = publicFile;
    }

    public boolean getInsertSourceMarkers() {
        return this.insertSourceMarkers;
    }

    public void setInsertSourceMarkers(boolean insertSourceMarkers) {
        this.insertSourceMarkers = insertSourceMarkers;
    }

    public static class ConfigAction
    implements TaskConfigAction<MergeResources> {
        @NonNull
        private VariantScope scope;
        @NonNull
        private String taskNamePrefix;
        @Nullable
        private File outputLocation;
        private boolean includeDependencies;
        private boolean process9Patch;

        public ConfigAction(@NonNull VariantScope scope, @NonNull String taskNamePrefix, @Nullable File outputLocation, boolean includeDependencies, boolean process9Patch) {
            this.scope = scope;
            this.taskNamePrefix = taskNamePrefix;
            this.outputLocation = outputLocation;
            this.includeDependencies = includeDependencies;
            this.process9Patch = process9Patch;
            scope.setMergeResourceOutputDir(outputLocation);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(this.taskNamePrefix, "Resources");
        }

        @Override
        public Class<MergeResources> getType() {
            return MergeResources.class;
        }

        public void execute(MergeResources mergeResourcesTask) {
            final BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            mergeResourcesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            mergeResourcesTask.setIncrementalFolder(new File(this.scope.getGlobalScope().getBuildDir() + "/" + "intermediates" + "/incremental/" + this.taskNamePrefix + "Resources" + variantData.getVariantConfiguration().getDirName()));
            mergeResourcesTask.process9Patch = this.process9Patch;
            mergeResourcesTask.crunchPng = this.scope.getGlobalScope().getExtension().getAaptOptions().getCruncherEnabled();
            mergeResourcesTask.normalizeResources = this.scope.getGlobalScope().getExtension().getBuildToolsRevision().compareTo(NORMALIZE_RESOURCES_BUILD_TOOLS) < 0;
            ConventionMappingHelper.map((Task)mergeResourcesTask, "useNewCruncher", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ConfigAction.this.scope.getGlobalScope().getExtension().getAaptOptions().getUseNewCruncher();
                }
            });
            ConventionMappingHelper.map((Task)mergeResourcesTask, "inputResourceSets", new Callable<List<ResourceSet>>(){

                @Override
                public List<ResourceSet> call() throws Exception {
                    ArrayList generatedResFolders = Lists.newArrayList((Object[])new File[]{ConfigAction.this.scope.getRenderscriptResOutputDir(), ConfigAction.this.scope.getGeneratedResOutputDir()});
                    if (variantData.getExtraGeneratedResFolders() != null) {
                        generatedResFolders.addAll(variantData.getExtraGeneratedResFolders());
                    }
                    if (variantData.generateApkDataTask != null && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
                        generatedResFolders.add(variantData.generateApkDataTask.getResOutputDir());
                    }
                    return variantData.getVariantConfiguration().getResourceSets(generatedResFolders, ConfigAction.this.includeDependencies);
                }
            });
            ConventionMappingHelper.map((Task)mergeResourcesTask, "outputDir", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return ConfigAction.this.outputLocation != null ? ConfigAction.this.outputLocation : ConfigAction.this.scope.getDefaultMergeResourcesOutputDir();
                }
            });
            variantData.mergeResourcesTask = mergeResourcesTask;
        }
    }
}

