/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.builder.png.VectorDrawableRenderer;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.PreprocessDataSet;
import com.android.ide.common.res2.PreprocessResourcesMerger;
import com.android.ide.common.res2.PreprocessResourcesWriter;
import com.android.resources.Density;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;

public class PreprocessResourcesTask
extends IncrementalTask {
    public static final int MIN_SDK = 21;
    private final VectorDrawableRenderer renderer = new VectorDrawableRenderer();
    private File outputResDirectory;
    private File generatedResDirectory;
    private File mergedResDirectory;
    private EnumSet<Density> densitiesToGenerate;
    private String variantName;

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) {
        PreprocessResourcesMerger merger = new PreprocessResourcesMerger();
        try {
            Files.touch((File)new File(this.getIncrementalFolder(), "build_was_incremental"));
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            if (!((Object)merger.getDensities()).equals(this.densitiesToGenerate)) {
                this.getLogger().info("Set of densities for generating PNG files changed, starting from scratch.");
                this.doFullTaskAction();
                return;
            }
            HashMultimap generatedFiles = HashMultimap.create();
            for (PreprocessDataSet preprocessDataSet : merger.getDataSets()) {
                preprocessDataSet.setGeneratedResDirectory(this.getGeneratedResDirectory());
                preprocessDataSet.setMergedResDirectory(this.getMergedResDirectory());
                preprocessDataSet.setGeneratedFiles((SetMultimap)generatedFiles);
            }
            for (Map.Entry entry : changedInputs.entrySet()) {
                switch ((FileStatus)entry.getValue()) {
                    case CHANGED: 
                    case NEW: {
                        this.handleFile((File)entry.getKey(), (FileStatus)entry.getValue(), merger.getMergedDataSet(), merger.getGeneratedDataSet(), (SetMultimap<File, File>)generatedFiles);
                        break;
                    }
                    case REMOVED: {
                        merger.getMergedDataSet().updateWith(this.getMergedResDirectory(), (File)entry.getKey(), FileStatus.REMOVED, this.getILogger());
                        merger.getGeneratedDataSet().updateWith(this.getMergedResDirectory(), (File)entry.getKey(), FileStatus.REMOVED, this.getILogger());
                    }
                }
            }
            this.finalizeMerge(merger);
        }
        catch (MergingException e) {
            merger.cleanBlob(this.getIncrementalFolder());
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            merger.cleanBlob(this.getIncrementalFolder());
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doFullTaskAction() {
        HashMultimap generatedFiles = HashMultimap.create();
        this.emptyFolder(this.getOutputResDirectory());
        this.emptyFolder(this.getGeneratedResDirectory());
        this.emptyFolder(this.getIncrementalFolder());
        PreprocessDataSet mergedSet = new PreprocessDataSet(this.getVariantName(), PreprocessDataSet.ResourcesDirectory.MERGED);
        mergedSet.addSource(this.getMergedResDirectory());
        mergedSet.setMergedResDirectory(this.getMergedResDirectory());
        PreprocessDataSet generatedSet = new PreprocessDataSet(this.getVariantName(), PreprocessDataSet.ResourcesDirectory.GENERATED);
        generatedSet.addSource(this.getMergedResDirectory());
        generatedSet.setGeneratedResDirectory(this.getGeneratedResDirectory());
        generatedSet.setGeneratedFiles((SetMultimap)generatedFiles);
        try {
            for (File resourceFile : this.getProject().fileTree((Object)this.getMergedResDirectory())) {
                this.handleFile(resourceFile, FileStatus.NEW, mergedSet, generatedSet, (SetMultimap<File, File>)generatedFiles);
            }
            PreprocessResourcesMerger merger = new PreprocessResourcesMerger();
            merger.setDensities(this.densitiesToGenerate);
            merger.addDataSet(generatedSet);
            merger.addDataSet(mergedSet);
            this.finalizeMerge(merger);
        }
        catch (MergingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void finalizeMerge(PreprocessResourcesMerger merger) throws MergingException {
        PreprocessResourcesWriter writer = new PreprocessResourcesWriter(this.getOutputResDirectory());
        merger.mergeData((MergeConsumer)writer, true);
        merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer);
    }

    private void handleFile(File resourceFile, FileStatus fileStatus, PreprocessDataSet mergedSet, PreprocessDataSet generatedSet, SetMultimap<File, File> generatedFiles) throws IOException, MergingException {
        if (this.renderer.needsPreprocessing(resourceFile)) {
            Collection newFiles = this.renderer.createPngFiles(resourceFile, this.getGeneratedResDirectory(), this.getDensitiesToGenerate());
            generatedFiles.putAll((Object)resourceFile, (Iterable)newFiles);
            generatedSet.updateWith(this.getMergedResDirectory(), resourceFile, fileStatus, this.getILogger());
        } else {
            mergedSet.updateWith(this.getMergedResDirectory(), resourceFile, fileStatus, this.getILogger());
        }
    }

    @OutputDirectory
    public File getGeneratedResDirectory() {
        return this.generatedResDirectory;
    }

    public void setGeneratedResDirectory(File generatedResDirectory) {
        this.generatedResDirectory = generatedResDirectory;
    }

    @InputDirectory
    public File getMergedResDirectory() {
        return this.mergedResDirectory;
    }

    public void setMergedResDirectory(File mergedResDirectory) {
        this.mergedResDirectory = mergedResDirectory;
    }

    @OutputDirectory
    public File getOutputResDirectory() {
        return this.outputResDirectory;
    }

    public void setOutputResDirectory(File outputResDirectory) {
        this.outputResDirectory = outputResDirectory;
    }

    public Collection<Density> getDensitiesToGenerate() {
        return this.densitiesToGenerate;
    }

    public void setDensitiesToGenerate(Collection<Density> densitiesToGenerate) {
        this.densitiesToGenerate = EnumSet.copyOf(densitiesToGenerate);
    }

    public String getVariantName() {
        return this.variantName;
    }

    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    @Input
    public String getDensitiesFingerprint() {
        return Joiner.on((char)':').join(this.densitiesToGenerate);
    }
}

