/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import java.io.IOException;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateMessageParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public final class AnnotateCommand
extends AbstractCommand {
    private boolean useHeadIfNotFound;
    private String date;
    private String revisionOrTag;
    private boolean annotateBinary;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventManager, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        try {
            cvsFiles = this.scanFileSystem(clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests(CommandRequest.ANNOTATE, clientEnvironment);
        requests.addArgumentRequest(this.isUseHeadIfNotFound(), "-f");
        requests.addArgumentRequest(this.getDate(), "-D");
        requests.addArgumentRequest(this.getRevisionOrTag(), "-r");
        requests.addArgumentRequest(this.isAnnotateBinary(), "-F");
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        requests.addLocalPathDirectoryRequest();
        this.addArgumentRequests(requests);
        AnnotateMessageParser parser = new AnnotateMessageParser(eventManager, clientEnvironment.getCvsFileSystem());
        parser.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, FileStateRequestsProgressHandler.create(progressViewer, cvsFiles));
            return bl;
        }
        finally {
            parser.unregisterListeners(listenerRegistry);
        }
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
        this.setDate(null);
        this.setAnnotateByRevisionOrTag(null);
        this.setUseHeadIfNotFound(false);
        this.setAnnotateBinary(false);
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("annotate ");
        cvsCommandLine.append(this.getCvsArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    private String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    private String getRevisionOrTag() {
        return this.revisionOrTag;
    }

    public void setAnnotateByRevisionOrTag(String annotateByRevision) {
        this.revisionOrTag = annotateByRevision;
    }

    private boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    private void setUseHeadIfNotFound(boolean useHeadIfNotFound) {
        this.useHeadIfNotFound = useHeadIfNotFound;
    }

    private boolean isAnnotateBinary() {
        return this.annotateBinary;
    }

    public void setAnnotateBinary(boolean annotateBinary) {
        this.annotateBinary = annotateBinary;
    }

    private String getCvsArguments() {
        StringBuilder cvsArguments = new StringBuilder("");
        if (!this.isRecursive()) {
            cvsArguments.append("-l ");
        }
        if (this.getRevisionOrTag() != null) {
            cvsArguments.append("-r ");
            cvsArguments.append(this.getRevisionOrTag());
            cvsArguments.append(" ");
        }
        if (this.getDate() != null) {
            cvsArguments.append("-D ");
            cvsArguments.append(this.getDate());
            cvsArguments.append(" ");
        }
        if (this.isUseHeadIfNotFound()) {
            cvsArguments.append("-f ");
        }
        if (this.isAnnotateBinary()) {
            cvsArguments.append("-F ");
        }
        return cvsArguments.toString();
    }
}

