/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDefault;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.schema.SqlJetTypeAffinity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetBtreeDataTable
extends SqlJetBtreeTable
implements ISqlJetBtreeDataTable {
    private static final String[] rowIdNames = new String[]{"ROWID", "_ROWID_", "OID"};
    private SqlJetTableDef tableDef;
    private Map<String, ISqlJetIndexDef> indexesDefs;
    private Map<String, ISqlJetBtreeIndexTable> indexesTables;
    private ISqlJetBtreeDataTable sequenceTable;
    private ISqlJetBtreeRecord defaults;

    public SqlJetBtreeDataTable(ISqlJetBtree btree, String tableName, boolean write) throws SqlJetException {
        super(btree, ((SqlJetTableDef)btree.getSchema().getTable(tableName)).getPage(), write, false);
        this.tableDef = (SqlJetTableDef)btree.getSchema().getTable(tableName);
        this.defaults = SqlJetBtreeRecord.getRecord(this.getEncoding(), this.getDefaults());
        this.openIndexes(btree.getSchema());
    }

    @Override
    public void close() throws SqlJetException {
        if (this.indexesTables != null) {
            for (String key : this.indexesTables.keySet()) {
                ISqlJetBtreeIndexTable table = this.indexesTables.get(key);
                table.close();
            }
        }
        if (null != this.sequenceTable) {
            this.sequenceTable.close();
        }
        super.close();
    }

    private void openIndexes(ISqlJetSchema schema) throws SqlJetException {
        this.indexesDefs = new TreeMap<String, ISqlJetIndexDef>(String.CASE_INSENSITIVE_ORDER);
        this.indexesTables = new TreeMap<String, ISqlJetBtreeIndexTable>(String.CASE_INSENSITIVE_ORDER);
        for (ISqlJetIndexDef indexDef : schema.getIndexes(this.tableDef.getName())) {
            SqlJetBtreeIndexTable indexTable;
            this.indexesDefs.put(indexDef.getName(), indexDef);
            if (indexDef.getColumns().size() > 0) {
                indexTable = new SqlJetBtreeIndexTable(this.btree, indexDef.getName(), this.write);
            } else {
                ArrayList<String> columns;
                if (this.tableDef.getTableIndexConstraint(indexDef.getName()) != null) {
                    columns = this.tableDef.getTableIndexConstraint(indexDef.getName()).getColumns();
                } else {
                    columns = new ArrayList<String>();
                    columns.add(this.tableDef.getColumnIndexConstraint(indexDef.getName()).getColumn().getName());
                }
                indexTable = new SqlJetBtreeIndexTable(this.btree, indexDef.getName(), columns, this.write);
            }
            this.indexesTables.put(indexDef.getName(), indexTable);
        }
    }

    @Override
    public ISqlJetTableDef getDefinition() {
        return this.tableDef;
    }

    @Override
    public Map<String, ISqlJetIndexDef> getIndexDefinitions() {
        return Collections.unmodifiableMap(this.indexesDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean goToRow(long rowId) throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            if (this.getRowId() == rowId) {
                boolean bl = true;
                return bl;
            }
            int moveTo = this.getCursor().moveTo(null, rowId, false);
            if (moveTo < 0) {
                this.next();
            }
            boolean bl = this.getRowId() == rowId;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRowId() throws SqlJetException {
        this.lock();
        try {
            long l = this.getCursor().getKeySize();
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long insert(SqlJetConflictAction onConflict, Object ... values) throws SqlJetException {
        return this.insertWithRowId(onConflict, 0L, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertWithRowId(SqlJetConflictAction onConflict, long rowId, Object[] values) throws SqlJetException {
        this.lock();
        try {
            Object[] row = this.getValuesRowForInsert(values);
            this.adjustRowIdPosition(values, row);
            if (onConflict == SqlJetConflictAction.REPLACE) {
                rowId = this.getRowIdForReplace(rowId, values, row);
            }
            if (rowId < 1L) {
                rowId = this.getRowIdForRow(row, true);
            }
            this.doInsert(onConflict, rowId, row);
            long l = rowId;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    private void adjustRowIdPosition(Object[] values, Object[] row) {
        int primaryKeyColumnNumber;
        if (row != null && row.length > 1 && this.tableDef.isRowIdPrimaryKey() && (values == null || values.length < row.length && row[values.length] == null) && (primaryKeyColumnNumber = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName())) >= 0 && primaryKeyColumnNumber < row.length && row[primaryKeyColumnNumber] != null) {
            System.arraycopy(row, primaryKeyColumnNumber, row, primaryKeyColumnNumber + 1, values.length - primaryKeyColumnNumber);
            row[primaryKeyColumnNumber] = null;
        }
    }

    private long getRowIdForReplace(long rowId, Object[] values, Object[] row) throws SqlJetException {
        String pkIndex = this.getPrimaryKeyIndex();
        if (pkIndex == null) {
            long rowIdForRow;
            if (this.tableDef.isRowIdPrimaryKey() && (rowIdForRow = this.getRowIdForRow(row, false)) > 0L) {
                return rowIdForRow;
            }
        } else {
            ISqlJetIndexDef indexDef = this.getIndexDefinitions().get(pkIndex);
            Object[] keyForIndex = this.getKeyForIndex(values, indexDef);
            if (this.isNotUnique(pkIndex, false, keyForIndex)) {
                return this.getRowId();
            }
        }
        for (ISqlJetIndexDef indexDef : this.getIndexDefinitions().values()) {
            if (!indexDef.isUnique()) continue;
            Object[] keyForIndex = this.getKeyForIndex(values, indexDef);
            if (!this.isNotUnique(indexDef.getName(), false, keyForIndex)) continue;
            return this.getRowId();
        }
        return rowId;
    }

    private boolean isNotUnique(String indexName, boolean next, Object ... key) throws SqlJetException {
        if (this.hasNull(key)) {
            return false;
        }
        return this.locate(indexName, next, key);
    }

    private Object[] getValuesRowForInsert(Object ... values) throws SqlJetException {
        Object[] row = new Object[this.tableDef.getColumns().size()];
        if (null != values && values.length != 0) {
            if (values.length > row.length) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Values count is more than columns in table");
            }
            Object[] a = SqlJetUtility.adjustNumberTypes(values);
            System.arraycopy(a, 0, row, 0, a.length);
        }
        return row;
    }

    private Object[] getValuesRowForUpdate(Object ... values) throws SqlJetException {
        Object[] row = new Object[this.tableDef.getColumns().size()];
        Object[] existingValues = this.getValues();
        System.arraycopy(existingValues, 0, row, 0, Math.min(existingValues.length, row.length));
        if (null != values && values.length != 0) {
            if (values.length > row.length) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Values count is more than columns in table");
            }
            Object[] a = SqlJetUtility.adjustNumberTypes(values);
            System.arraycopy(a, 0, row, 0, a.length);
        }
        return row;
    }

    private Object[] getDefaults() throws SqlJetException {
        Object[] row = new Object[this.tableDef.getColumns().size()];
        if (this.btree.getDb().getOptions().getFileFormat() > 2) {
            for (int i = 0; i < this.tableDef.getColumns().size(); ++i) {
                ISqlJetColumnDef column = this.tableDef.getColumns().get(i);
                for (ISqlJetColumnConstraint constraint : column.getConstraints()) {
                    if (!(constraint instanceof ISqlJetColumnDefault)) continue;
                    ISqlJetColumnDefault d = (ISqlJetColumnDefault)constraint;
                    row[i] = d.getExpression().getValue();
                }
            }
        }
        return row;
    }

    private long getRowIdForRow(Object[] row, boolean required) throws SqlJetException {
        if (this.tableDef.isRowIdPrimaryKey()) {
            int primaryKeyColumnNumber = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName());
            if (primaryKeyColumnNumber == -1 || primaryKeyColumnNumber >= row.length) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            Object rowIdParam = row[primaryKeyColumnNumber];
            if (null != rowIdParam) {
                if (rowIdParam instanceof Long) {
                    long rowId = (Long)rowIdParam;
                    if (rowId > 0L) {
                        return rowId;
                    }
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "INTEGER PRIMARY KEY column must be more than zero");
                }
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "INTEGER PRIMARY KEY column must have only integer value");
            }
        }
        if (required) {
            return this.newRowId();
        }
        return 0L;
    }

    @Override
    public long newRowId() throws SqlJetException {
        if (!this.tableDef.isAutoincremented()) {
            return super.newRowId();
        }
        if (null == this.sequenceTable) {
            this.sequenceTable = this.btree.getSchema().openSequenceTable();
            if (null == this.sequenceTable) {
                return super.newRowId();
            }
            return this.locateSequence();
        }
        String s = this.sequenceTable.getString(0);
        if (null == s || !this.tableDef.getName().equalsIgnoreCase(s)) {
            return this.locateSequence();
        }
        return this.updateSequence();
    }

    private long locateSequence() throws SqlJetException {
        this.sequenceTable.first();
        while (!this.sequenceTable.eof()) {
            String s = this.sequenceTable.getString(0);
            if (null != s && this.tableDef.getName().equalsIgnoreCase(s)) {
                return this.updateSequence();
            }
            this.sequenceTable.next();
        }
        long newRowId = super.newRowId();
        this.sequenceTable.insert(null, this.tableDef.getName(), newRowId);
        return newRowId;
    }

    private long updateSequence() throws SqlJetException {
        long lastRowId = this.sequenceTable.getInteger(1);
        long newRowId = this.newRowId(lastRowId);
        this.sequenceTable.updateCurrent(null, this.tableDef.getName(), newRowId);
        return newRowId;
    }

    private void doInsert(SqlJetConflictAction onConflict, long rowId, Object[] row) throws SqlJetException {
        ISqlJetMemoryPointer pData;
        SqlJetEncoding encoding = this.btree.getDb().getOptions().getEncoding();
        if (!this.tableDef.isRowIdPrimaryKey()) {
            pData = SqlJetBtreeRecord.getRecord(encoding, row).getRawRecord();
        } else {
            int primaryKeyColumnNumber = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName());
            if (primaryKeyColumnNumber == -1 || primaryKeyColumnNumber >= row.length) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            row[primaryKeyColumnNumber] = null;
            pData = SqlJetBtreeRecord.getRecord(encoding, row).getRawRecord();
            row[primaryKeyColumnNumber] = rowId;
        }
        if (this.doActionWithIndexes(Action.INSERT, onConflict, rowId, row)) {
            this.getCursor().insert(null, rowId, pData, pData.remaining(), 0, true);
            this.goToRow(rowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(SqlJetConflictAction onConflict, long rowId, Object ... values) throws SqlJetException {
        this.lock();
        try {
            if (rowId <= 0L || !this.goToRow(rowId)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Incorrect rowId value: " + rowId);
            }
            Object[] row = this.getValuesRowForUpdate(values);
            if (rowId < 1L) {
                rowId = this.getRowIdForRow(row, false);
            }
            this.doUpdate(onConflict, rowId, row);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCurrent(SqlJetConflictAction onConflict, Object ... values) throws SqlJetException {
        this.lock();
        try {
            if (this.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "No current record");
            }
            Object[] row = this.getValuesRowForUpdate(values);
            long rowId = this.getRowIdForRow(row, false);
            this.doUpdate(onConflict, rowId, row);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateWithRowId(SqlJetConflictAction onConflict, long rowId, long newRowId, Object ... values) throws SqlJetException {
        this.lock();
        try {
            if (rowId <= 0L || !this.goToRow(rowId)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Incorrect rowId value: " + rowId);
            }
            Object[] row = this.getValuesRowForUpdate(values);
            if (newRowId < 1L) {
                newRowId = this.getRowIdForRow(row, false);
            }
            this.doUpdate(onConflict, newRowId > 0L ? newRowId : rowId, row);
            long l = newRowId;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateCurrentWithRowId(SqlJetConflictAction onConflict, long newRowId, Object ... values) throws SqlJetException {
        this.lock();
        try {
            if (this.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "No current record");
            }
            Object[] row = this.getValuesRowForUpdate(values);
            if (newRowId < 1L) {
                newRowId = this.getRowIdForRow(row, false);
            }
            this.doUpdate(onConflict, newRowId, this.getValuesRowForUpdate(values));
            long l = newRowId;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    private void doUpdate(SqlJetConflictAction onConflict, long rowId, Object[] row) throws SqlJetException {
        ISqlJetMemoryPointer pData;
        long newRowId;
        long currentRowId = this.getRowId();
        Object[] currentRow = this.getValues();
        long l = newRowId = 0L < rowId ? rowId : currentRowId;
        if (newRowId == currentRowId && Arrays.equals(row, currentRow)) {
            return;
        }
        Object[] rowCompleted = this.completeRow(row, currentRow);
        if (newRowId == currentRowId && Arrays.equals(rowCompleted, currentRow)) {
            return;
        }
        SqlJetEncoding encoding = this.btree.getDb().getOptions().getEncoding();
        if (!this.tableDef.isRowIdPrimaryKey()) {
            pData = SqlJetBtreeRecord.getRecord(encoding, rowCompleted).getRawRecord();
        } else {
            int primaryKeyColumnNumber = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName());
            if (primaryKeyColumnNumber == -1 || primaryKeyColumnNumber >= rowCompleted.length) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            rowCompleted[primaryKeyColumnNumber] = null;
            pData = SqlJetBtreeRecord.getRecord(encoding, rowCompleted).getRawRecord();
            rowCompleted[primaryKeyColumnNumber] = newRowId;
        }
        if (this.doActionWithIndexes(Action.UPDATE, onConflict, newRowId, rowCompleted)) {
            boolean changeRowId;
            boolean bl = changeRowId = newRowId != currentRowId;
            if (changeRowId) {
                this.getCursor().delete();
            }
            this.getCursor().insert(null, newRowId, pData, pData.remaining(), 0, changeRowId);
            this.goToRow(newRowId);
        }
    }

    private Object[] completeRow(Object[] row, Object[] currentRow) {
        Object[] completeRow;
        if (row.length == currentRow.length) {
            return row;
        }
        if (row.length > currentRow.length) {
            completeRow = new Object[row.length];
            System.arraycopy(row, 0, completeRow, 0, row.length);
        } else {
            completeRow = new Object[currentRow.length];
            System.arraycopy(row, 0, completeRow, 0, row.length);
            System.arraycopy(currentRow, row.length, completeRow, row.length, currentRow.length - row.length);
        }
        return completeRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(long rowId) throws SqlJetException {
        this.lock();
        try {
            if (rowId <= 0L || !this.goToRow(rowId)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Incorrect rowId value: " + rowId);
            }
            this.doDelete();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws SqlJetException {
        this.lock();
        try {
            if (this.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "No current record");
            }
            this.doDelete();
        }
        finally {
            this.unlock();
        }
    }

    private void doDelete() throws SqlJetException {
        this.doActionWithIndexes(Action.DELETE, null, 0L, new Object[0]);
        long rowId = this.getRowId();
        this.getCursor().delete();
        this.goToRow(rowId);
    }

    private boolean isRowIdExists(long rowId) throws SqlJetException {
        return this.isRowIdExists(rowId, true);
    }

    private boolean isRowIdExists(long rowId, boolean keepPosition) throws SqlJetException {
        long current = this.getRowId();
        if (rowId == current) {
            return true;
        }
        boolean exists = this.goToRow(rowId);
        if (keepPosition) {
            if (current > 0L) {
                this.goToRow(current);
            } else {
                this.first();
            }
        }
        return exists;
    }

    private boolean doActionWithIndexes(Action action, SqlJetConflictAction onConflict, long rowId, Object ... row) throws SqlJetException {
        List<ISqlJetColumnDef> columns;
        if (null == onConflict) {
            onConflict = SqlJetConflictAction.ABORT;
        }
        boolean existsRowId = false;
        long currentRowId = 0L;
        Object[] currentRow = null;
        if (Action.INSERT != action) {
            currentRowId = this.getRowId();
            currentRow = this.getValues();
        }
        if (Action.INSERT == action) {
            long oldRowId = this.getRowId();
            existsRowId = this.isRowIdExists(rowId, false);
            if (!existsRowId && oldRowId > 0L) {
                this.goToRow(oldRowId);
            }
        } else if (Action.UPDATE == action && currentRowId != rowId) {
            existsRowId = this.isRowIdExists(rowId);
        }
        if (existsRowId) {
            switch (onConflict) {
                case IGNORE: {
                    return false;
                }
                case REPLACE: {
                    if (!this.goToRow(rowId)) break;
                    currentRowId = this.getRowId();
                    currentRow = this.getValues();
                    this.getCursor().delete();
                    break;
                }
                default: {
                    throw new SqlJetException(SqlJetErrorCode.CONSTRAINT, "Record with given ROWID already exists");
                }
            }
        }
        if (Action.DELETE != action && this.hasNull(row) && (columns = this.tableDef.getNotNullColumns()) != null && columns.size() != 0) {
            for (ISqlJetColumnDef column : columns) {
                String name = column.getName();
                int index = column.getIndex();
                if (row.length >= index && null != row[index] || SqlJetConflictAction.IGNORE == onConflict) continue;
                throw new SqlJetException(String.format("Field '%s' must be not NULL", name));
            }
        }
        class IndexKeys {
            ISqlJetBtreeIndexTable indexTable;
            Object[] currentKey;
            Object[] key;

            public IndexKeys(ISqlJetBtreeIndexTable indexTable, Object[] currentKey, Object[] key) {
                this.indexTable = indexTable;
                this.currentKey = currentKey;
                this.key = key;
            }
        }
        ArrayList<IndexKeys> indexKeys = new ArrayList<IndexKeys>(this.indexesDefs.size());
        block13: for (ISqlJetIndexDef indexDef : this.indexesDefs.values()) {
            long lookup;
            Object[] key;
            Object[] currentKey = Action.INSERT == action && SqlJetConflictAction.REPLACE != onConflict ? null : this.getKeyForIndex(currentRow, indexDef);
            Object[] objectArray = key = Action.DELETE == action ? null : this.getKeyForIndex(row, indexDef);
            if (Action.UPDATE == action && currentRowId == rowId && Arrays.deepEquals(currentKey, key)) continue;
            ISqlJetBtreeIndexTable indexTable = this.indexesTables.get(indexDef.getName());
            indexKeys.add(new IndexKeys(indexTable, currentKey, key));
            if (Action.DELETE == action || this.hasNull(key) || !indexDef.isUnique() && this.tableDef.getColumnIndexConstraint(indexDef.getName()) == null && this.tableDef.getTableIndexConstraint(indexDef.getName()) == null || (lookup = indexTable.lookup(false, key)) == 0L) continue;
            if (Action.INSERT == action) {
                switch (onConflict) {
                    case IGNORE: {
                        return false;
                    }
                    case REPLACE: {
                        indexTable.delete(lookup, key);
                        if (lookup == currentRowId || !this.isRowIdExists(lookup)) continue block13;
                        this.delete(lookup);
                        continue block13;
                    }
                }
                throw new SqlJetException(SqlJetErrorCode.CONSTRAINT, "Insert fails: unique index " + indexDef.getName());
            }
            if (Action.UPDATE != action || lookup == currentRowId) continue;
            switch (onConflict) {
                case IGNORE: {
                    return false;
                }
                case REPLACE: {
                    indexTable.delete(lookup, key);
                    continue block13;
                }
            }
            throw new SqlJetException(SqlJetErrorCode.CONSTRAINT, "Update fails: unique index " + indexDef.getName());
        }
        for (IndexKeys i : indexKeys) {
            if ((Action.INSERT != action || SqlJetConflictAction.REPLACE == onConflict) && currentRowId > 0L) {
                i.indexTable.delete(currentRowId, i.currentKey);
            }
            if (Action.DELETE == action) continue;
            i.indexTable.insert(rowId, true, i.key);
        }
        return true;
    }

    private boolean hasNull(Object[] row) {
        if (row != null && row.length > 0) {
            for (Object value : row) {
                if (null != value) continue;
                return true;
            }
        }
        return false;
    }

    private Object getFieldByName(Object[] fields, String name) {
        int columnNumber = this.tableDef.getColumnNumber(name);
        if (columnNumber >= 0 && fields.length > columnNumber) {
            return fields[columnNumber];
        }
        return null;
    }

    private Object getColumnValue(Object[] fields, ISqlJetColumnDef column) {
        int columnIndex = column.getIndex();
        if (columnIndex >= 0 && fields.length > columnIndex) {
            return fields[columnIndex];
        }
        return null;
    }

    public Object[] getKeyForIndex(Object[] fields, ISqlJetIndexDef indexDef) {
        if (null == fields) {
            return null;
        }
        if (this.tableDef.getColumnIndexConstraint(indexDef.getName()) != null) {
            SqlJetColumnDef column = this.tableDef.getColumnIndexConstraint(indexDef.getName()).getColumn();
            return new Object[]{this.getColumnValue(fields, column)};
        }
        if (this.tableDef.getTableIndexConstraint(indexDef.getName()) != null) {
            List<String> columns = this.tableDef.getTableIndexConstraint(indexDef.getName()).getColumns();
            int columnsCount = columns.size();
            Object[] key = new Object[columnsCount];
            int i = 0;
            for (String column : columns) {
                key[i++] = this.getFieldByName(fields, column);
            }
            return key;
        }
        List<ISqlJetIndexedColumn> indexedColumns = indexDef.getColumns();
        int columnsCount = indexedColumns.size();
        Object[] key = new Object[columnsCount];
        int i = 0;
        for (ISqlJetIndexedColumn column : indexedColumns) {
            key[i++] = this.getColumnValue(fields, column.getTableColumn());
        }
        return key;
    }

    @Override
    public boolean checkIndex(String indexName, Object[] key) throws SqlJetException {
        if (!this.isIndexExists(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE);
        }
        if (null != indexName) {
            return Arrays.equals(key, this.getKeyForIndex(this.getValues(), this.indexesDefs.get(indexName)));
        }
        return this.getRowId() == this.getKeyForRowId(key).longValue();
    }

    private Long getKeyForRowId(Object[] key) throws SqlJetException {
        Object k;
        if (!this.tableDef.isRowIdPrimaryKey()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not defined");
        }
        if (key.length == 1 && (k = SqlJetUtility.adjustNumberType(key[0])) instanceof Long) {
            return (Long)k;
        }
        throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad key");
    }

    @Override
    public String getPrimaryKeyIndex() {
        return this.tableDef.isRowIdPrimaryKey() ? null : this.tableDef.getPrimaryKeyIndexName();
    }

    @Override
    public boolean locate(String indexName, boolean next, Object ... key) throws SqlJetException {
        if (null == key) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad key");
        }
        if (null != indexName) {
            if (!this.indexesDefs.containsKey(indexName)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not found: " + indexName);
            }
            ISqlJetBtreeIndexTable indexTable = this.indexesTables.get(indexName);
            long lookup = indexTable.lookup(next, key);
            return lookup != 0L && this.goToRow(lookup);
        }
        if (next) {
            return this.next();
        }
        return this.goToRow(this.getKeyForRowId(key));
    }

    @Override
    public Map<String, ISqlJetBtreeIndexTable> getIndexesTables() {
        return Collections.unmodifiableMap(this.indexesTables);
    }

    @Override
    public long insert(SqlJetConflictAction onConflict, Map<String, Object> values) throws SqlJetException {
        return this.insertWithRowId(onConflict, SqlJetBtreeDataTable.getRowIdFromValues(values), this.unwrapValues(values));
    }

    @Override
    public void update(SqlJetConflictAction onConflict, long rowId, Map<String, Object> values) throws SqlJetException {
        this.updateWithRowId(onConflict, rowId, SqlJetBtreeDataTable.getRowIdFromValues(values), this.unwrapValues(values, this.getValues()));
    }

    @Override
    public void update(SqlJetConflictAction onConflict, Map<String, Object> values) throws SqlJetException {
        this.updateWithRowId(onConflict, this.getRowId(), SqlJetBtreeDataTable.getRowIdFromValues(values), this.unwrapValues(values, this.getValues()));
    }

    private Object[] unwrapValues(Map<String, Object> values) throws SqlJetException {
        return this.unwrapValues(values, null);
    }

    private Object[] unwrapValues(Map<String, Object> values, Object[] defaults) throws SqlJetException {
        int i = 0;
        Object[] unwrapped = new Object[this.tableDef.getColumns().size()];
        if (null != values) {
            for (ISqlJetColumnDef column : this.tableDef.getColumns()) {
                String columnName = column.getName();
                if (values.containsKey(columnName)) {
                    unwrapped[i] = values.get(columnName);
                } else if (defaults != null && defaults.length > i) {
                    unwrapped[i] = defaults[i];
                }
                ++i;
            }
        }
        return unwrapped;
    }

    @Override
    public long getInteger(int field) throws SqlJetException {
        if (field == this.tableDef.getRowIdPrimaryKeyColumnIndex()) {
            return this.getRowId();
        }
        return super.getInteger(field);
    }

    @Override
    public Object getValue(int field) throws SqlJetException {
        if (field == this.tableDef.getRowIdPrimaryKeyColumnIndex()) {
            return this.getRowId();
        }
        return super.getValue(field);
    }

    @Override
    public boolean isIndexExists(String indexName) {
        return null == indexName || this.getIndexDefinitions().containsKey(indexName);
    }

    public static boolean isFieldNameRowId(String fieldName) {
        if (null == fieldName) {
            return false;
        }
        for (int i = 0; i < rowIdNames.length; ++i) {
            if (!rowIdNames[i].equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static long getRowIdFromValues(Map<String, Object> values) throws SqlJetException {
        if (null == values) {
            return 0L;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            for (int i = 0; i < rowIdNames.length; ++i) {
                if (!rowIdNames[i].equalsIgnoreCase(name) || null == value) continue;
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "ROWID must be integer value");
            }
        }
        return 0L;
    }

    @Override
    public void clear() throws SqlJetException {
        for (ISqlJetBtreeIndexTable index : this.indexesTables.values()) {
            index.clear();
        }
        super.clear();
    }

    @Override
    protected ISqlJetVdbeMem getValueMem(int field) throws SqlJetException {
        ISqlJetVdbeMem valueMem = super.getValueMem(field);
        if (field < this.defaults.getFieldsCount() && (valueMem == null || valueMem.isNull())) {
            valueMem = this.defaults.getFields().get(field);
        }
        if (valueMem != null) {
            valueMem.applyAffinity(this.getFieldAffinity(field), this.getEncoding());
        }
        return valueMem;
    }

    private SqlJetTypeAffinity getFieldAffinity(int field) throws SqlJetException {
        List<ISqlJetColumnDef> columns = this.getDefinition().getColumns();
        if (field < 0 || field >= columns.size()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad value for field number");
        }
        return columns.get(field).getTypeAffinity();
    }

    @Override
    public ISqlJetBtreeIndexTable getIndex(String indexName) {
        return this.indexesTables.get(indexName);
    }

    @Override
    public boolean isNull(int field) throws SqlJetException {
        if (field == this.tableDef.getRowIdPrimaryKeyColumnIndex()) {
            return this.eof();
        }
        return super.isNull(field);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        INSERT,
        UPDATE,
        DELETE;

    }
}

