/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.logging.StyledTextOutput;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinaryRenderer<T extends BinarySpec>
extends ReportRenderer<BinarySpec, TextReportBuilder> {
    public void render(BinarySpec binary, TextReportBuilder builder) {
        StyledTextOutput textOutput = builder.getOutput();
        textOutput.append((CharSequence)StringUtils.capitalize((String)binary.getDisplayName()));
        if (!binary.isBuildable()) {
            textOutput.append((CharSequence)" (not buildable)");
        }
        textOutput.println();
        builder.item("build using task", binary.getBuildTask().getPath());
        BinarySpec specialized = (BinarySpec)this.getTargetType().cast(binary);
        this.renderTasks(specialized, builder);
        this.renderDetails(specialized, builder);
        this.renderOutputs(specialized, builder);
        this.renderBuildAbility(specialized, builder);
    }

    public abstract Class<T> getTargetType();

    protected void renderOutputs(T binary, TextReportBuilder builder) {
    }

    protected void renderDetails(T binary, TextReportBuilder builder) {
    }

    protected void renderTasks(T binary, TextReportBuilder builder) {
    }

    private void renderBuildAbility(BinarySpec binary, TextReportBuilder builder) {
        BinaryBuildAbility buildAbility = ((BinarySpecInternal)binary).getBuildAbility();
        if (!buildAbility.isBuildable()) {
            TreeFormatter formatter = new TreeFormatter();
            buildAbility.explain((TreeVisitor)formatter);
            builder.item(formatter.toString());
        }
    }
}

