/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.reporting.components.internal.ComponentRenderer;
import org.gradle.api.reporting.components.internal.SourceSetRenderer;
import org.gradle.api.reporting.components.internal.TypeAwareBinaryRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.logging.StyledTextOutput;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentReportRenderer
extends TextReportRenderer {
    private final ComponentRenderer componentRenderer;
    private final SourceSetRenderer sourceSetRenderer;
    private final TypeAwareBinaryRenderer binaryRenderer;
    private final Set<LanguageSourceSet> componentSourceSets = new HashSet<LanguageSourceSet>();
    private final Set<BinarySpec> componentBinaries = new HashSet<BinarySpec>();

    public ComponentReportRenderer(FileResolver fileResolver, TypeAwareBinaryRenderer binaryRenderer) {
        this.setFileResolver(fileResolver);
        this.sourceSetRenderer = new SourceSetRenderer();
        this.binaryRenderer = binaryRenderer;
        this.componentRenderer = new ComponentRenderer(this.sourceSetRenderer, binaryRenderer);
    }

    @Override
    public void complete() {
        this.getTextOutput().println();
        this.getTextOutput().println((Object)"Note: currently not all plugins register their components, so some components may not be visible here.");
        super.complete();
    }

    public void renderComponents(Collection<ComponentSpec> components) {
        if (components.isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No components defined for this project.");
            return;
        }
        boolean seen = false;
        for (ComponentSpec component : components) {
            if (seen) {
                this.getBuilder().getOutput().println();
            } else {
                seen = true;
            }
            this.componentRenderer.render(component, this.getBuilder());
            this.componentSourceSets.addAll((Collection<LanguageSourceSet>)component.getSource());
            this.componentBinaries.addAll((Collection<BinarySpec>)component.getBinaries());
        }
    }

    public void renderSourceSets(Collection<LanguageSourceSet> sourceSets) {
        LinkedHashSet<LanguageSourceSet> additionalSourceSets = new LinkedHashSet<LanguageSourceSet>();
        for (LanguageSourceSet sourceSet : sourceSets) {
            if (this.componentSourceSets.contains(sourceSet)) continue;
            additionalSourceSets.add(sourceSet);
        }
        if (!additionalSourceSets.isEmpty()) {
            this.getBuilder().getOutput().println();
            this.getBuilder().subheading("Additional source sets");
            for (LanguageSourceSet sourceSet : additionalSourceSets) {
                this.sourceSetRenderer.render(sourceSet, this.getBuilder());
            }
        }
    }

    public void renderBinaries(Collection<BinarySpec> binaries) {
        LinkedHashSet<BinarySpec> additionalBinaries = new LinkedHashSet<BinarySpec>();
        for (BinarySpec binary : binaries) {
            if (this.componentBinaries.contains(binary)) continue;
            additionalBinaries.add(binary);
        }
        if (!additionalBinaries.isEmpty()) {
            this.getBuilder().getOutput().println();
            this.getBuilder().subheading("Additional binaries");
            for (BinarySpec binary : additionalBinaries) {
                try {
                    this.binaryRenderer.render(binary, this.getBuilder());
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        }
    }
}

