/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import java.io.File;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.logging.StyledTextOutput;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceSetRenderer
extends ReportRenderer<LanguageSourceSet, TextReportBuilder> {
    SourceSetRenderer() {
    }

    public void render(LanguageSourceSet sourceSet, TextReportBuilder builder) {
        StyledTextOutput textOutput = builder.getOutput();
        textOutput.println((Object)StringUtils.capitalize((String)sourceSet.getDisplayName()));
        Set srcDirs = sourceSet.getSource().getSrcDirs();
        if (srcDirs.isEmpty()) {
            textOutput.println((Object)"    No source directories");
        } else {
            Set excludes;
            for (File file : srcDirs) {
                builder.item(file);
            }
            SourceDirectorySet source = sourceSet.getSource();
            Set includes = source.getIncludes();
            if (!includes.isEmpty()) {
                builder.item("includes", CollectionUtils.join((String)", ", (Iterable)includes));
            }
            if (!(excludes = source.getExcludes()).isEmpty()) {
                builder.item("excludes", CollectionUtils.join((String)", ", (Iterable)excludes));
            }
        }
    }
}

