/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.reporting.components.internal.AbstractBinaryRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.platform.base.BinarySpec;
import org.gradle.reporting.ReportRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeAwareBinaryRenderer
extends ReportRenderer<BinarySpec, TextReportBuilder> {
    private final Map<Class<?>, ReportRenderer<BinarySpec, TextReportBuilder>> renderers = new HashMap();

    public void register(AbstractBinaryRenderer<?> renderer) {
        this.renderers.put(renderer.getTargetType(), renderer);
    }

    public void render(BinarySpec model, TextReportBuilder output) throws IOException {
        ReportRenderer<BinarySpec, TextReportBuilder> renderer = this.getRendererForType(model.getClass());
        renderer.render((Object)model, (Object)output);
    }

    private ReportRenderer<BinarySpec, TextReportBuilder> getRendererForType(Class<? extends BinarySpec> type) {
        ReportRenderer<BinarySpec, TextReportBuilder> renderer = this.renderers.get(type);
        if (renderer == null) {
            Class<?> bestType = null;
            for (Map.Entry<Class<?>, ReportRenderer<BinarySpec, TextReportBuilder>> entry : this.renderers.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type) || bestType != null && !bestType.isAssignableFrom(entry.getKey())) continue;
                bestType = entry.getKey();
                renderer = entry.getValue();
            }
            this.renderers.put(type, renderer);
        }
        return renderer;
    }
}

