/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.model.internal;

import java.util.TreeMap;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.type.ModelType;
import org.gradle.reporting.ReportRenderer;

public class ModelReportRenderer
extends TextReportRenderer {
    private final NodeRenderer nodeRenderer = new NodeRenderer();

    public void render(ModelNode node) {
        this.nodeRenderer.render(node, this.getBuilder());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeRenderer
    extends ReportRenderer<ModelNode, TextReportBuilder> {
        private NodeRenderer() {
        }

        public void render(ModelNode model, TextReportBuilder output) {
            if (model.isHidden()) {
                return;
            }
            if (model.getPath().equals((Object)ModelPath.ROOT)) {
                output.getOutput().println((Object)"model");
            } else {
                output.getOutput().println((Object)model.getPath().getName());
            }
            TreeMap<String, ModelNode> links = new TreeMap<String, ModelNode>();
            for (ModelNode node : model.getLinks(ModelType.untyped())) {
                links.put(node.getPath().getName(), node);
            }
            output.collection(links.values(), this);
        }
    }
}

