/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.text;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.LinePrefixingStyledTextOutput;
import org.gradle.reporting.ReportRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTextReportBuilder
implements TextReportBuilder {
    public static final String SEPARATOR = "------------------------------------------------------------";
    private StyledTextOutput textOutput;
    private final FileResolver fileResolver;

    public DefaultTextReportBuilder(StyledTextOutput textOutput, FileResolver fileResolver) {
        this.textOutput = textOutput;
        this.fileResolver = fileResolver;
    }

    @Override
    public void item(String title, String value) {
        this.textOutput.append((CharSequence)"    ").append((CharSequence)title).append((CharSequence)": ");
        LinePrefixingStyledTextOutput itemOutput = new LinePrefixingStyledTextOutput(this.textOutput, (CharSequence)"    ");
        itemOutput.append((CharSequence)value).println();
    }

    @Override
    public void item(String title, File value) {
        this.item(title, this.fileResolver.resolveAsRelativePath((Object)value));
    }

    @Override
    public void item(String value) {
        this.textOutput.append((CharSequence)"    ");
        LinePrefixingStyledTextOutput itemOutput = new LinePrefixingStyledTextOutput(this.textOutput, (CharSequence)"    ");
        itemOutput.append((CharSequence)value).println();
    }

    @Override
    public void item(File value) {
        this.item(this.fileResolver.resolveAsRelativePath((Object)value));
    }

    @Override
    public void heading(String heading) {
        this.textOutput.println().style(StyledTextOutput.Style.Header);
        this.textOutput.println((Object)SEPARATOR);
        this.textOutput.println((Object)heading);
        this.textOutput.text((Object)SEPARATOR);
        this.textOutput.style(StyledTextOutput.Style.Normal);
        this.textOutput.println().println();
    }

    @Override
    public void subheading(String heading) {
        this.textOutput.style(StyledTextOutput.Style.Header).println((Object)heading);
        for (int i = 0; i < heading.length(); ++i) {
            this.textOutput.text((Object)"-");
        }
        this.textOutput.style(StyledTextOutput.Style.Normal).println();
    }

    @Override
    public <T> void collection(String title, Collection<? extends T> items, ReportRenderer<T, TextReportBuilder> renderer, String elementsPlural) {
        this.textOutput.println((Object)title);
        if (items.isEmpty()) {
            this.textOutput.formatln("    No %s.", new Object[]{elementsPlural});
            return;
        }
        this.collection(items, renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> void collection(Iterable<? extends T> items, ReportRenderer<T, TextReportBuilder> renderer) {
        StyledTextOutput original = this.textOutput;
        boolean hasItem = false;
        try {
            this.textOutput = new LinePrefixingStyledTextOutput(original, (CharSequence)"    ");
            for (T t : items) {
                if (!hasItem) {
                    this.textOutput.append((CharSequence)"    ");
                    hasItem = true;
                }
                try {
                    renderer.render(t, (Object)this);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            this.textOutput = original;
        }
    }

    @Override
    public StyledTextOutput getOutput() {
        return this.textOutput;
    }
}

