/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login.ui;

import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.ui.NoUsersListItem;
import com.google.gct.login.ui.UsersListCellRenderer;
import com.google.gct.login.ui.UsersListItem;
import com.intellij.ide.BrowserUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GoogleLoginUsersPanel
extends JPanel
implements ListSelectionListener {
    private static final String PLAY_CONSOLE_URL = "https://play.google.com/apps/publish/#ProfilePlace";
    private static final String CLOUD_CONSOLE_URL = "https://console.developers.google.com/accountsettings";
    private static final String LEARN_MORE_URL = "https://developers.google.com/cloud/devtools/android_studio_templates/";
    private static final String ADD_ACCOUNT = "Add Account";
    private static final String SIGN_IN = "Sign In";
    private static final String SIGN_OUT = "Sign Out";
    private static final int MAX_VISIBLE_ROW_COUNT = 3;
    private JBList myList;
    private DefaultListModel myListModel;
    private JButton mySignOutButton;
    private boolean myValueChanged;
    private boolean myIgnoreSelection;

    public GoogleLoginUsersPanel() {
        super(new BorderLayout());
        int indexToSelect = this.initializeUsers();
        final UsersListCellRenderer usersListCellRenderer = new UsersListCellRenderer();
        this.myList = new JBList(this.myListModel){

            public Dimension getPreferredScrollableViewportSize() {
                int numUsers = GoogleLoginUsersPanel.this.myListModel.size();
                Dimension superPreferredSize = super.getPreferredScrollableViewportSize();
                if (numUsers <= 1) {
                    return superPreferredSize;
                }
                if (GoogleLogin.getInstance().getActiveUser() == null) {
                    return superPreferredSize;
                }
                if (!GoogleLoginUsersPanel.this.isActiveUserInVisibleArea()) {
                    return superPreferredSize;
                }
                int usersToShow = numUsers > 3 ? 3 : numUsers;
                int scrollHeight = (usersToShow - 1) * usersListCellRenderer.getMainPanelHeight() + usersListCellRenderer.getActivePanelHeight();
                return new Dimension((int)superPreferredSize.getWidth(), scrollHeight);
            }
        };
        this.myList.setSelectionMode(0);
        this.myList.setSelectedIndex(indexToSelect);
        this.myList.addListSelectionListener((ListSelectionListener)this);
        this.myList.setVisibleRowCount(this.getVisibleRowCount());
        this.myList.setCellRenderer((ListCellRenderer)usersListCellRenderer);
        JBScrollPane listScrollPane = new JBScrollPane((Component)this.myList);
        this.myList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int index;
                GoogleLoginUsersPanel.this.myList.updateUI();
                if (GoogleLoginUsersPanel.this.myListModel.getSize() == 1 && GoogleLoginUsersPanel.this.myListModel.get(0) instanceof NoUsersListItem) {
                    if (usersListCellRenderer.inLearnMoreUrl(mouseEvent.getPoint())) {
                        BrowserUtil.browse((String)GoogleLoginUsersPanel.LEARN_MORE_URL);
                    }
                } else if (!GoogleLoginUsersPanel.this.myValueChanged && (index = GoogleLoginUsersPanel.this.myList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    boolean inPlayUrl = usersListCellRenderer.inPlayConsoleUrl(mouseEvent.getPoint(), index);
                    if (inPlayUrl) {
                        BrowserUtil.browse((String)GoogleLoginUsersPanel.PLAY_CONSOLE_URL);
                    } else {
                        boolean inCloudUrl = usersListCellRenderer.inCloudConsoleUrl(mouseEvent.getPoint(), index);
                        if (inCloudUrl) {
                            BrowserUtil.browse((String)GoogleLoginUsersPanel.CLOUD_CONSOLE_URL);
                        }
                    }
                }
                GoogleLoginUsersPanel.this.myValueChanged = false;
            }
        });
        this.myList.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int index = GoogleLoginUsersPanel.this.myList.locationToIndex(mouseEvent.getPoint());
                if (index >= 0) {
                    Object currentObject = GoogleLoginUsersPanel.this.myListModel.get(index);
                    if (currentObject instanceof NoUsersListItem) {
                        if (usersListCellRenderer.inLearnMoreUrl(mouseEvent.getPoint())) {
                            GoogleLoginUsersPanel.this.myList.setCursor(new Cursor(12));
                        } else {
                            GoogleLoginUsersPanel.this.myList.setCursor(new Cursor(0));
                        }
                        return;
                    }
                    if (((UsersListItem)currentObject).isActiveUser()) {
                        boolean inPlayUrl = usersListCellRenderer.inPlayConsoleUrl(mouseEvent.getPoint(), index);
                        boolean inCloudUrl = usersListCellRenderer.inCloudConsoleUrl(mouseEvent.getPoint(), index);
                        if (inPlayUrl || inCloudUrl) {
                            GoogleLoginUsersPanel.this.myList.setCursor(new Cursor(12));
                        } else {
                            GoogleLoginUsersPanel.this.myList.setCursor(new Cursor(0));
                        }
                    } else {
                        GoogleLoginUsersPanel.this.myList.setCursor(new Cursor(12));
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        boolean noUsersAvailable = this.myListModel.getSize() == 1 && this.myListModel.get(0) instanceof NoUsersListItem;
        JButton addAccountButton = new JButton(noUsersAvailable ? SIGN_IN : ADD_ACCOUNT);
        addAccountButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoogleLogin.getInstance().logIn();
            }
        });
        addAccountButton.setHorizontalAlignment(2);
        this.mySignOutButton = new JButton(SIGN_OUT);
        this.mySignOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoogleLogin.getInstance().logOut();
            }
        });
        if (this.myList.isSelectionEmpty()) {
            this.mySignOutButton.setEnabled(false);
        } else if (noUsersAvailable) {
            this.mySignOutButton.setVisible(false);
        } else {
            this.mySignOutButton.setEnabled(true);
        }
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(addAccountButton);
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.mySignOutButton);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)listScrollPane, "Center");
        this.add((Component)buttonPane, "Last");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.myIgnoreSelection) {
            return;
        }
        this.myValueChanged = true;
        if (!e.getValueIsAdjusting()) {
            if (this.myList.getSelectedIndex() == -1) {
                this.mySignOutButton.setEnabled(false);
            } else {
                this.mySignOutButton.setEnabled(true);
                UsersListItem selectedUser = (UsersListItem)this.myListModel.get(this.myList.getSelectedIndex());
                if (!selectedUser.isActiveUser()) {
                    GoogleLogin.getInstance().setActiveUser(selectedUser.getUserEmail());
                }
                this.myIgnoreSelection = true;
                try {
                    this.myListModel.remove(this.myList.getSelectedIndex());
                    this.myListModel.add(0, selectedUser);
                    this.myList.setSelectedIndex(0);
                }
                finally {
                    this.myIgnoreSelection = false;
                }
            }
        }
    }

    public JBList getList() {
        return this.myList;
    }

    private int initializeUsers() {
        LinkedHashMap<String, CredentialedUser> allUsers = GoogleLogin.getInstance().getAllUsers();
        this.myListModel = new DefaultListModel();
        int activeUserIndex = allUsers.size();
        for (CredentialedUser aUser : allUsers.values()) {
            this.myListModel.addElement(new UsersListItem(aUser));
            if (!aUser.isActive()) continue;
            activeUserIndex = this.myListModel.getSize() - 1;
        }
        if (this.myListModel.getSize() == 0) {
            this.myListModel.addElement(NoUsersListItem.INSTANCE);
        } else if (activeUserIndex != 0 && activeUserIndex < this.myListModel.getSize()) {
            UsersListItem activeUser = (UsersListItem)this.myListModel.remove(activeUserIndex);
            this.myListModel.add(0, activeUser);
            activeUserIndex = 0;
        }
        return activeUserIndex;
    }

    private int getVisibleRowCount() {
        if (this.myListModel == null) {
            return 0;
        }
        int size = this.myListModel.getSize();
        if (size >= 3) {
            return 3;
        }
        if (size == 0) {
            return 3;
        }
        return size;
    }

    private boolean isActiveUserInVisibleArea() {
        int max = this.myListModel.getSize() < 3 ? this.myListModel.getSize() : 3;
        for (int i = 0; i < max; ++i) {
            if (!((UsersListItem)this.myListModel.get(i)).isActiveUser()) continue;
            return true;
        }
        return false;
    }
}

