/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.configure;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeExecutableBinarySpec;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeBinarySpecInitializer
implements Action<NativeBinarySpec> {
    private final File binariesOutputDir;

    public NativeBinarySpecInitializer(File buildDir) {
        this.binariesOutputDir = new File(buildDir, "binaries");
    }

    public void execute(NativeBinarySpec nativeBinary) {
        BinaryNamingScheme namingScheme = ((NativeBinarySpecInternal)nativeBinary).getNamingScheme();
        PlatformToolProvider toolProvider = ((NativeBinarySpecInternal)nativeBinary).getPlatformToolProvider();
        File binaryOutputDir = new File(this.binariesOutputDir, namingScheme.getOutputDirectoryBase());
        String baseName = nativeBinary.getComponent().getBaseName();
        if (nativeBinary instanceof NativeExecutableBinarySpec) {
            ((NativeExecutableBinarySpec)nativeBinary).setExecutableFile(new File(binaryOutputDir, toolProvider.getExecutableName(baseName)));
        } else if (nativeBinary instanceof SharedLibraryBinarySpec) {
            ((SharedLibraryBinarySpec)nativeBinary).setSharedLibraryFile(new File(binaryOutputDir, toolProvider.getSharedLibraryName(baseName)));
            ((SharedLibraryBinarySpec)nativeBinary).setSharedLibraryLinkFile(new File(binaryOutputDir, toolProvider.getSharedLibraryLinkFileName(baseName)));
        } else if (nativeBinary instanceof StaticLibraryBinarySpec) {
            ((StaticLibraryBinarySpec)nativeBinary).setStaticLibraryFile(new File(binaryOutputDir, toolProvider.getStaticLibraryName(baseName)));
        }
    }
}

