/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibraryRequirement;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.LibraryResolveException;
import org.gradle.nativeplatform.internal.resolve.ProjectLocator;
import org.gradle.platform.base.ComponentSpecContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final ProjectLocator projectLocator;

    public ProjectLibraryBinaryLocator(ProjectLocator projectLocator) {
        this.projectLocator = projectLocator;
    }

    @Override
    public DomainObjectSet<NativeLibraryBinary> getBinaries(NativeLibraryRequirement requirement) {
        Project project = this.findProject(requirement);
        ComponentSpecContainer componentSpecContainer = (ComponentSpecContainer)project.getExtensions().findByType(ComponentSpecContainer.class);
        if (componentSpecContainer == null) {
            throw new LibraryResolveException(String.format("Project does not have a libraries container: '%s'", project.getPath()));
        }
        DomainObjectSet projectBinaries = ((NativeLibrarySpec)componentSpecContainer.withType(NativeLibrarySpec.class).getByName(requirement.getLibraryName())).getBinaries().withType(NativeBinarySpec.class);
        DefaultDomainObjectSet binaries = new DefaultDomainObjectSet(NativeLibraryBinary.class);
        for (NativeBinarySpec nativeBinarySpec : projectBinaries) {
            binaries.add((Object)((NativeLibraryBinary)((Object)nativeBinarySpec)));
        }
        return binaries;
    }

    private Project findProject(NativeLibraryRequirement requirement) {
        return this.projectLocator.locateProject(requirement.getProjectPath());
    }
}

