/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.plugins;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Namer;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.DefaultPolymorphicDomainObjectContainer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.BuildTypeContainer;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.FlavorContainer;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeExecutableSpec;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.PrebuiltLibraries;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.Repositories;
import org.gradle.nativeplatform.internal.DefaultBuildTypeContainer;
import org.gradle.nativeplatform.internal.DefaultFlavorContainer;
import org.gradle.nativeplatform.internal.DefaultNativeExecutableSpec;
import org.gradle.nativeplatform.internal.DefaultNativeLibrarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.NativePlatformResolver;
import org.gradle.nativeplatform.internal.configure.DefaultNativeBinariesFactory;
import org.gradle.nativeplatform.internal.configure.NativeBinarySpecInitializer;
import org.gradle.nativeplatform.internal.configure.NativeComponentSpecInitializer;
import org.gradle.nativeplatform.internal.configure.ToolSettingNativeBinaryInitializer;
import org.gradle.nativeplatform.internal.pch.DefaultPreCompiledHeaderTransformContainer;
import org.gradle.nativeplatform.internal.pch.PreCompiledHeaderTransformContainer;
import org.gradle.nativeplatform.internal.prebuilt.DefaultPrebuiltLibraries;
import org.gradle.nativeplatform.internal.prebuilt.PrebuiltLibraryInitializer;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.tasks.PrefixHeaderFileGenerateTask;
import org.gradle.nativeplatform.toolchain.internal.DefaultNativeToolChainRegistry;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class NativeComponentModelPlugin
implements Plugin<ProjectInternal> {
    private final Instantiator instantiator;

    @Inject
    public NativeComponentModelPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
        project.getExtensions().create("buildTypes", DefaultBuildTypeContainer.class, new Object[]{this.instantiator});
        project.getExtensions().create("flavors", DefaultFlavorContainer.class, new Object[]{this.instantiator});
        project.getExtensions().create("toolChains", DefaultNativeToolChainRegistry.class, new Object[]{this.instantiator});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtifactRepositoryNamer
    implements Namer<ArtifactRepository> {
        private ArtifactRepositoryNamer() {
        }

        public String determineName(ArtifactRepository object) {
            return object.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultRepositories
    extends DefaultPolymorphicDomainObjectContainer<ArtifactRepository>
    implements Repositories {
        private DefaultRepositories(final Instantiator instantiator, final FileResolver fileResolver, final Action<PrebuiltLibrary> binaryFactory) {
            super(ArtifactRepository.class, instantiator, (Namer)new ArtifactRepositoryNamer());
            this.registerFactory(PrebuiltLibraries.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<PrebuiltLibraries>(){

                public PrebuiltLibraries create(String name) {
                    return (PrebuiltLibraries)instantiator.newInstance(DefaultPrebuiltLibraries.class, new Object[]{name, instantiator, fileResolver, binaryFactory});
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void nativeExecutable(ComponentTypeBuilder<NativeExecutableSpec> builder) {
            builder.defaultImplementation(DefaultNativeExecutableSpec.class);
        }

        @ComponentType
        void nativeLibrary(ComponentTypeBuilder<NativeLibrarySpec> builder) {
            builder.defaultImplementation(DefaultNativeLibrarySpec.class);
        }

        @Model
        Repositories repositories(ServiceRegistry serviceRegistry, FlavorContainer flavors, PlatformContainer platforms, BuildTypeContainer buildTypes) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            PrebuiltLibraryInitializer initializer = new PrebuiltLibraryInitializer(instantiator, (Collection<? extends NativePlatform>)platforms.withType(NativePlatform.class), (Collection<? extends BuildType>)((Object)buildTypes), (Collection<? extends Flavor>)((Object)flavors));
            return new DefaultRepositories(instantiator, fileResolver, initializer);
        }

        @Model
        NativeToolChainRegistryInternal toolChains(ExtensionContainer extensionContainer) {
            return (NativeToolChainRegistryInternal)extensionContainer.getByType(NativeToolChainRegistryInternal.class);
        }

        @Model
        BuildTypeContainer buildTypes(ExtensionContainer extensionContainer) {
            return (BuildTypeContainer)extensionContainer.getByType(BuildTypeContainer.class);
        }

        @Model
        FlavorContainer flavors(ExtensionContainer extensionContainer) {
            return (FlavorContainer)extensionContainer.getByType(FlavorContainer.class);
        }

        @Model
        NamedDomainObjectSet<NativeComponentSpec> nativeComponents(ComponentSpecContainer components) {
            return components.withType(NativeComponentSpec.class);
        }

        @Model
        PreCompiledHeaderTransformContainer preCompiledHeaderTransformContainer(ServiceRegistry serviceRegistry) {
            return (PreCompiledHeaderTransformContainer)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultPreCompiledHeaderTransformContainer.class, new Object[0]);
        }

        @Mutate
        public void registerNativePlatformResolver(PlatformResolvers resolvers) {
            resolvers.register((PlatformResolver)new NativePlatformResolver());
        }

        @Defaults
        public void registerFactoryForCustomNativePlatforms(PlatformContainer platforms, ServiceRegistry serviceRegistry) {
            final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            NamedDomainObjectFactory<NativePlatform> nativePlatformFactory = new NamedDomainObjectFactory<NativePlatform>(){

                public NativePlatform create(String name) {
                    return (NativePlatform)instantiator.newInstance(DefaultNativePlatform.class, new Object[]{name});
                }
            };
            platforms.registerFactory(NativePlatform.class, (NamedDomainObjectFactory)nativePlatformFactory);
            platforms.registerFactory(Platform.class, (NamedDomainObjectFactory)nativePlatformFactory);
        }

        @Mutate
        public void createNativeBinaries(BinaryContainer binaries, NamedDomainObjectSet<NativeComponentSpec> nativeComponents, LanguageTransformContainer languageTransforms, NativeToolChainRegistryInternal toolChains, PlatformResolvers platforms, BuildTypeContainer buildTypes, FlavorContainer flavors, ServiceRegistry serviceRegistry, @Path(value="buildDir") File buildDir, ITaskFactory taskFactory) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            NativeDependencyResolver resolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
            NativeBinarySpecInitializer configureBinaryAction = new NativeBinarySpecInitializer(buildDir);
            ToolSettingNativeBinaryInitializer setToolsAction = new ToolSettingNativeBinaryInitializer(languageTransforms);
            Action initAction = Actions.composite((Action[])new Action[]{configureBinaryAction, setToolsAction});
            DefaultNativeBinariesFactory factory = new DefaultNativeBinariesFactory(instantiator, (Action<NativeBinarySpec>)initAction, resolver, taskFactory);
            DefaultBinaryNamingSchemeBuilder namingSchemeBuilder = new DefaultBinaryNamingSchemeBuilder();
            NativeComponentSpecInitializer createBinariesAction = new NativeComponentSpecInitializer(factory, (BinaryNamingSchemeBuilder)namingSchemeBuilder, toolChains, platforms, (Collection<? extends BuildType>)((Object)buildTypes), (Collection<? extends Flavor>)((Object)flavors));
            for (NativeComponentSpec component : nativeComponents) {
                createBinariesAction.execute(component);
                binaries.addAll((Collection)component.getBinaries());
            }
        }

        @Finalize
        public void createDefaultToolChain(NativeToolChainRegistryInternal toolChains) {
            if (toolChains.isEmpty()) {
                toolChains.addDefaultToolChains();
            }
        }

        @Finalize
        public void createDefaultBuildTypes(BuildTypeContainer buildTypes) {
            if (buildTypes.isEmpty()) {
                buildTypes.create("debug");
            }
        }

        @Finalize
        public void createDefaultFlavor(FlavorContainer flavors) {
            if (flavors.isEmpty()) {
                flavors.create("default");
            }
        }

        @Mutate
        void configureGeneratedSourceSets(CollectionBuilder<ComponentSpec> componentSpecs) {
            componentSpecs.afterEach((Action)new Action<ComponentSpec>(){

                public void execute(ComponentSpec componentSpec) {
                    for (LanguageSourceSetInternal languageSourceSet : componentSpec.getSource().withType(LanguageSourceSetInternal.class)) {
                        Task generatorTask = languageSourceSet.getGeneratorTask();
                        if (generatorTask == null) continue;
                        languageSourceSet.builtBy(new Object[]{generatorTask});
                        Rules.this.maybeSetSourceDir(languageSourceSet.getSource(), generatorTask, "sourceDir");
                        if (!(languageSourceSet instanceof HeaderExportingSourceSet)) continue;
                        Rules.this.maybeSetSourceDir(((HeaderExportingSourceSet)languageSourceSet).getExportedHeaders(), generatorTask, "headerDir");
                    }
                }
            });
        }

        @Mutate
        void configurePrefixHeaderFiles(CollectionBuilder<ComponentSpec> componentSpecs, final @Path(value="buildDir") File buildDir) {
            componentSpecs.afterEach((Action)new Action<ComponentSpec>(){

                public void execute(ComponentSpec componentSpec) {
                    for (DependentSourceSet dependentSourceSet : componentSpec.getSource().withType(DependentSourceSet.class)) {
                        if (!CollectionUtils.isNotEmpty(dependentSourceSet.getPreCompiledHeaders())) continue;
                        String prefixHeaderDirName = String.format("tmp/%s/prefixHeaders", dependentSourceSet.getName());
                        File prefixHeaderDir = new File(buildDir, prefixHeaderDirName);
                        File prefixHeaderFile = new File(prefixHeaderDir, "prefix-headers.h");
                        dependentSourceSet.setPrefixHeaderFile(prefixHeaderFile);
                    }
                }
            });
        }

        @Mutate
        void configurePrefixHeaderGenerationTasks(final TaskContainer tasks, NamedDomainObjectSet<NativeComponentSpec> nativeComponents) {
            for (NativeComponentSpec nativeComponentSpec : nativeComponents) {
                nativeComponentSpec.getSource().withType(DependentSourceSet.class, (Action)new Action<DependentSourceSet>(){

                    public void execute(final DependentSourceSet dependentSourceSet) {
                        if (dependentSourceSet.getPrefixHeaderFile() != null) {
                            String taskName = String.format("generate%sPrefixHeaderFile", StringUtils.capitalize((String)dependentSourceSet.getName()));
                            tasks.create(taskName, PrefixHeaderFileGenerateTask.class, (Action)new Action<PrefixHeaderFileGenerateTask>(){

                                public void execute(PrefixHeaderFileGenerateTask prefixHeaderFileGenerateTask) {
                                    prefixHeaderFileGenerateTask.setPrefixHeaderFile(dependentSourceSet.getPrefixHeaderFile());
                                    prefixHeaderFileGenerateTask.setHeaders(dependentSourceSet.getPreCompiledHeaders());
                                }
                            });
                        }
                    }
                });
            }
        }

        @Mutate
        void configurePreCompiledHeaderCompileTasks(CollectionBuilder<NativeBinarySpecInternal> binaries, ServiceRegistry serviceRegistry, final PreCompiledHeaderTransformContainer pchTransformContainer, @Path(value="buildDir") File buildDir) {
            binaries.all((Action)new Action<NativeBinarySpecInternal>(){

                public void execute(final NativeBinarySpecInternal nativeBinarySpec) {
                    Iterator i$ = pchTransformContainer.iterator();
                    while (i$.hasNext()) {
                        final LanguageTransform transform = (LanguageTransform)i$.next();
                        nativeBinarySpec.getSource().withType(transform.getSourceSetType(), (Action)new Action<LanguageSourceSet>(){

                            public void execute(LanguageSourceSet languageSourceSet) {
                                final DependentSourceSet dependentSourceSet = (DependentSourceSet)languageSourceSet;
                                if (CollectionUtils.isNotEmpty(dependentSourceSet.getPreCompiledHeaders())) {
                                    final SourceTransformTaskConfig taskConfig = transform.getTransformTask();
                                    String pchTaskName = String.format("%s%s%sPreCompiledHeader", taskConfig.getTaskPrefix(), StringUtils.capitalize((String)nativeBinarySpec.getName()), StringUtils.capitalize((String)dependentSourceSet.getName()));
                                    nativeBinarySpec.getTasks().create(pchTaskName, taskConfig.getTaskType(), (Action)new Action<DefaultTask>(){

                                        public void execute(DefaultTask task) {
                                            taskConfig.configureTask((Task)task, (BinarySpec)nativeBinarySpec, (LanguageSourceSet)dependentSourceSet);
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });
        }

        @Mutate
        public void applyHeaderSourceSetConventions(CollectionBuilder<ComponentSpec> componentSpecs) {
            componentSpecs.afterEach((Action)new Action<ComponentSpec>(){

                public void execute(ComponentSpec componentSpec) {
                    DomainObjectSet functionalSourceSet = componentSpec.getSource();
                    for (HeaderExportingSourceSet headerSourceSet : functionalSourceSet.withType(HeaderExportingSourceSet.class)) {
                        if (headerSourceSet.getExportedHeaders().getSrcDirs().isEmpty()) {
                            headerSourceSet.getExportedHeaders().srcDir((Object)String.format("src/%s/headers", componentSpec.getName()));
                        }
                        headerSourceSet.getImplicitHeaders().setSrcDirs((Iterable)headerSourceSet.getSource().getSrcDirs());
                        headerSourceSet.getImplicitHeaders().include(new String[]{"**/*.h"});
                    }
                }
            });
        }

        private void maybeSetSourceDir(SourceDirectorySet sourceSet, Task task, String propertyName) {
            Object value = task.property(propertyName);
            if (value != null) {
                sourceSet.srcDir(value);
            }
        }
    }
}

