/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixHeaderFileGeneratorUtil {
    public static void generatePCHFile(Set<String> headers, File headerFile) {
        if (!headerFile.getParentFile().exists()) {
            headerFile.getParentFile().mkdirs();
        }
        try {
            FileUtils.writeLines((File)headerFile, (Collection)CollectionUtils.collect((List)CollectionUtils.toList(headers), (Transformer)new Transformer<String, String>(){

                public String transform(String header) {
                    if (header.startsWith("<")) {
                        return "#include ".concat(header);
                    }
                    return "#include \"".concat(header).concat("\"");
                }
            }));
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

