/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.gradle.api.Transformer;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeCompiler;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppOptionsFileArgsWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VisualCppNativeCompiler<T extends NativeCompileSpec>
extends NativeCompiler<T> {
    VisualCppNativeCompiler(BuildOperationProcessor buildOperationProcessor, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, ArgsTransformer<T> argsTransformer, Transformer<T, T> specTransformer, String objectFileExtension, boolean useCommandFile) {
        super(buildOperationProcessor, commandLineToolInvocationWorker, invocationContext, argsTransformer, specTransformer, objectFileExtension, useCommandFile);
    }

    @Override
    protected List<String> getOutputArgs(T spec, File outputFile) {
        return Collections.singletonList("/Fo" + outputFile.getAbsolutePath());
    }

    @Override
    protected void addOptionsFileArgs(List<String> args, File tempDir) {
        VisualCppOptionsFileArgsWriter writer = new VisualCppOptionsFileArgsWriter(tempDir);
        writer.execute(args);
    }

    @Override
    protected List<String> getPCHArgs(T spec) {
        ArrayList<String> pchArgs = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(spec.getPreCompiledHeaders()) && spec.getPreCompiledHeaderObjectFile() != null) {
            String lastHeader = (String)CollectionUtils.get(spec.getPreCompiledHeaders(), (int)(spec.getPreCompiledHeaders().size() - 1));
            if (lastHeader.startsWith("<")) {
                lastHeader = lastHeader.substring(1, lastHeader.length() - 1);
            }
            pchArgs.add("/Yu".concat(lastHeader));
            pchArgs.add("/Fp".concat(spec.getPreCompiledHeaderObjectFile().getAbsolutePath()));
        }
        return pchArgs;
    }
}

